/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BooleanType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.ListType;
import org.hibernate.type.LongType;
import org.hibernate.type.SetType;
import org.hibernate.type.TimeType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonHelper {
    public static Map<String, Object> toMap(JSONObject object, String entityType, SessionFactory sessionFactory) throws ParseException, JSONException {
        ClassMetadata classData = sessionFactory.getClassMetadata(entityType);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iter = object.keys();
        while (iter.hasNext()) {
            Type propType;
            Object value;
            String key = (String)iter.next();
            try {
                value = object.get(key);
            }
            catch (JSONException e) {
                throw new RuntimeException("\u6570\u636e\u9519\u8bef\uff0ckey: " + key, e);
            }
            try {
                propType = classData.getPropertyType(key);
            }
            catch (HibernateException e) {
                continue;
            }
            if (object.isNull(key)) {
                if ("id".equals(key)) continue;
                map.put(key, null);
                continue;
            }
            if (value instanceof JSONArray && propType instanceof SetType) {
                Set<Map<String, Object>> set = JsonHelper.saveSet((JSONArray)value, sessionFactory);
                map.put(key, set);
                continue;
            }
            if (value instanceof JSONArray && propType instanceof ListType) {
                List<Map<String, Object>> set = JsonHelper.saveList((JSONArray)value, sessionFactory);
                map.put(key, set);
                continue;
            }
            if (value instanceof JSONObject) {
                String type;
                JSONObject obj = (JSONObject)value;
                try {
                    type = (String)obj.get("EntityType");
                }
                catch (JSONException e) {
                    throw new RuntimeException("\u7f3a\u5c11EntityType", e);
                }
                Map<String, Object> set = JsonHelper.toMap((JSONObject)value, type, sessionFactory);
                map.put(key, set);
                continue;
            }
            if (propType instanceof DateType || propType instanceof TimeType || propType instanceof TimestampType) {
                Date date = null;
                String s = value.toString();
                if (!StringUtils.isEmpty((String)s)) {
                    SimpleDateFormat sdf;
                    String[] split = s.split(" ");
                    if (propType instanceof DateType) {
                        sdf = new SimpleDateFormat("yyyy-MM-dd");
                        date = sdf.parse(split[0]);
                    }
                    if (propType instanceof TimeType) {
                        sdf = new SimpleDateFormat("HH:mm:ss");
                        date = sdf.parse(split[1]);
                    }
                    if (propType instanceof TimestampType) {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        date = sdf.parse(s);
                    }
                }
                map.put(key, date);
                continue;
            }
            if (propType instanceof DoubleType) {
                double v = Double.parseDouble(value.toString());
                map.put(key, v);
                continue;
            }
            if (propType instanceof BigDecimalType) {
                map.put(key, new BigDecimal(value.toString()));
                continue;
            }
            if (value instanceof Integer && propType instanceof LongType) {
                Long v = Long.valueOf(value.toString());
                map.put(key, v);
                continue;
            }
            if (propType instanceof BooleanType) {
                map.put(key, value);
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, Object> toMap(JSONObject object) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (object == null) {
            return map;
        }
        Iterator iter = object.keys();
        while (iter.hasNext()) {
            Object set;
            Object value;
            String key = (String)iter.next();
            try {
                value = object.get(key);
            }
            catch (JSONException e) {
                throw new RuntimeException("\u6570\u636e\u9519\u8bef\uff0ckey: " + key, e);
            }
            if (value instanceof JSONArray) {
                set = JsonHelper.saveList((JSONArray)value);
                map.put(key, set);
                continue;
            }
            if (value instanceof JSONObject) {
                set = JsonHelper.toMap((JSONObject)value);
                map.put(key, set);
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, Object> toMap(Map<String, Object> object, String entityType, SessionFactory sessionFactory) throws Exception {
        ClassMetadata classData = sessionFactory.getClassMetadata(entityType);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : object.keySet()) {
            Type propType;
            Object value = object.get(key);
            try {
                propType = classData.getPropertyType(key);
            }
            catch (HibernateException e) {
                continue;
            }
            if (value == null) {
                if ("id".equals(key)) continue;
                map.put(key, null);
                continue;
            }
            if (value instanceof List && propType instanceof SetType) {
                Set<Map<String, Object>> set = JsonHelper.saveSet((List)value, sessionFactory);
                map.put(key, set);
                continue;
            }
            if (value instanceof List && propType instanceof ListType) {
                List<Map<String, Object>> set = JsonHelper.saveList((List)value, sessionFactory);
                map.put(key, set);
                continue;
            }
            if (value instanceof Map) {
                Map obj = (Map)value;
                String type = (String)obj.get("EntityType");
                if (type == null) {
                    throw new RuntimeException("\u7f3a\u5c11EntityType");
                }
                Map<String, Object> set = JsonHelper.toMap(obj, type, sessionFactory);
                map.put(key, set);
                continue;
            }
            if (propType instanceof DateType || propType instanceof TimeType) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date date = sdf.parse(value.toString());
                map.put(key, date);
                continue;
            }
            if (propType instanceof DoubleType) {
                double v = Double.parseDouble(value.toString());
                map.put(key, v);
                continue;
            }
            if (propType instanceof BigDecimalType) {
                map.put(key, new BigDecimal(value.toString()));
                continue;
            }
            if (value instanceof Integer && propType instanceof LongType) {
                Long v = Long.valueOf(value.toString());
                map.put(key, v);
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    private static Set<Map<String, Object>> saveSet(JSONArray array, SessionFactory sessionFactory) throws JSONException, ParseException {
        HashSet<Map<String, Object>> set = new HashSet<Map<String, Object>>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject obj = (JSONObject)array.get(i);
            String type = (String)obj.get("EntityType");
            Map<String, Object> map = JsonHelper.toMap(obj, type, sessionFactory);
            set.add(map);
        }
        return set;
    }

    private static List<Map<String, Object>> saveList(JSONArray array, SessionFactory sessionFactory) throws JSONException, ParseException {
        ArrayList<Map<String, Object>> set = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject obj = (JSONObject)array.get(i);
            String type = (String)obj.get("EntityType");
            Map<String, Object> map = JsonHelper.toMap(obj, type, sessionFactory);
            set.add(map);
        }
        return set;
    }

    private static List<Map<String, Object>> saveList(JSONArray array) throws Exception {
        ArrayList<Map<String, Object>> set = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject obj = (JSONObject)array.get(i);
            Map<String, Object> map = JsonHelper.toMap(obj);
            set.add(map);
        }
        return set;
    }

    private static Set<Map<String, Object>> saveSet(List<Map<String, Object>> array, SessionFactory sessionFactory) throws Exception {
        HashSet<Map<String, Object>> set = new HashSet<Map<String, Object>>();
        for (Map<String, Object> map : array) {
            String type = (String)map.get("EntityType");
            set.add(JsonHelper.toMap(map, type, sessionFactory));
        }
        return set;
    }

    private static List<Map<String, Object>> saveList(List<Map<String, Object>> array, SessionFactory sessionFactory) throws Exception {
        ArrayList<Map<String, Object>> set = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : array) {
            String type = (String)map.get("EntityType");
            set.add(JsonHelper.toMap(map, type, sessionFactory));
        }
        return set;
    }
}

