/*
 * Decompiled with CFR 0.152.
 */
package com.aote.listener;

import com.aote.rs.ManagerService;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.json.JSONArray;
import org.json.JSONObject;

public class KafkaConsumerListener
implements ServletContextListener {
    private static KafkaConsumer<String, String> consumer = null;

    public static synchronized KafkaConsumer<String, String> getConsumer() {
        if (consumer == null) {
            KafkaConsumerListener.initKafkaConsumer();
        }
        return consumer;
    }

    public void contextInitialized(ServletContextEvent sce) {
        System.out.println("===============================KafkaConsumerListener");
        KafkaConsumerListener.initKafkaConsumer();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (consumer != null) {
            consumer.close();
        }
    }

    private static void initKafkaConsumer() {
        Properties props = new Properties();
        ManagerService ms = new ManagerService();
        JSONObject config = new JSONObject(ms.getConfig());
        if (!config.has("kafka")) {
            return;
        }
        JSONObject kafka = config.getJSONObject("kafka");
        if (!kafka.has("server") || !kafka.has("topics")) {
            return;
        }
        try {
            String servers = kafka.getString("server");
            props.put("bootstrap.servers", servers);
            props.put("group.id", "g1");
            props.put("enable.auto.commit", "true");
            props.put("auto.commit.interval.ms", "1000");
            props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
            props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
            consumer = new KafkaConsumer(props);
            ArrayList<String> topics = new ArrayList<String>();
            JSONArray arr = kafka.getJSONArray("topics");
            for (int i = 0; i < arr.length(); ++i) {
                topics.add(arr.getString(i));
            }
            consumer.subscribe(topics);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

