package com.aote.rs;

import javax.inject.Singleton;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import com.aote.report.ReportServer;
import com.aote.util.ExceptionHelper;

@Path("report")
@Singleton
@Component
@Transactional
public class ReportService {
	static Logger log = Logger.getLogger(LogicService.class);

	@Autowired
	private ReportServer reportServer;

	// 调用报表服务，产生报表结果
	@POST
	@Path("{report}")
	public String xtSave(@PathParam("report") String reportName, String values)
			throws Exception {
		log.debug("report:" + reportName + ", values:" + values);
		try {
			Object result = reportServer.run(reportName, values);
			if (result == null) {
				return "";
			}
			return result.toString();
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			throw ex;
		}
	}
}
