package com.aote.report;

import org.dom4j.Element;

import com.af.expression.Delegate;
import com.af.expression.Program;

// 一个table的单元格
public class Cell {
	public int row = 0;
	public int column = 0;
	public int rowSpan = 1;
	public int columnSpan = 1;
	// 样式属性
	public String css = "";
	// 宽度
	public String width = "";
	// 高度
	public String height = "";

	// 是否下移
	public String isDown = "true";

	// 单元格表达式内容
	public String content = "";

	// 单元格是否html
	public String type = "";
	
	// 单元格表达式编译结果，所有表达式提前编译，执行时，只根据编译结果执行
	public Delegate delegate;

	// 对应的报表
	public Report report;

	// 根据xml元素构建
	public Cell(Element ele) {
		this.row = Integer.parseInt(ele.attributeValue("row"));
		this.column = Integer.parseInt(ele.attributeValue("column"));
		this.rowSpan = Integer.parseInt(ele.attributeValue("rowspan"));
		this.columnSpan = Integer.parseInt(ele.attributeValue("columnspan"));
		this.content = ele.attributeValue("content");
		this.css = ele.attributeValue("css");
		this.width = ele.attributeValue("width");
		this.height = ele.attributeValue("height");
		this.type = ele.attributeValue("type");
		this.isDown = ele.attributeValue("isDown");
	}

	public Cell(int row, int column, int rowSpan, int columnSpan, String content) {
		this.row = row;
		this.column = column;
		this.rowSpan = rowSpan;
		this.columnSpan = columnSpan;
		this.content = content;
	}

	public void setReport(Report report) {
		this.report = report;
	}

	// 对单元格的表达式进行编译
	public void compile() {
		// 空串不编译
		if (this.content == null || this.content.trim().equals("")) {
			return;
		}

		Program prog = new Program(this.content);
		this.delegate = prog.parse();
	}

	// 单元格执行表单式
	public Object invoke() {
		// 如果单元格为空，返回空串
		if (this.delegate == null) {
			return "";
		}
		return this.delegate.invoke(this.report.vars);
	}

	// 复制
	public Cell clone() {
		Cell result = new Cell(this.row, this.column, this.rowSpan,
				this.columnSpan, this.content);
		// 设置css,为了兼容前面程序，单独判断处理
		if (this.width != null && !this.width.equals("")) {
			result.width = this.width;
		}
		if (this.height != null && !this.height.equals("")) {
			result.height = this.height;
		}

		// 设置css,为了兼容前面程序，单独判断处理
		if (this.css != null && !this.css.equals("")) {
			result.css = this.css;
		}
		if (this.delegate != null) {
			result.delegate = this.delegate;
		}
		if (this.report != null) {
			result.report = this.report;
		}
		return result;
	}

	@Override
	public String toString() {
		return this.row + ":" + this.column;
	}
}
