package com.aote.plugin;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.json.JSONObject;

/**
 * 日期插件
 */
public class DatePlugin {

	/**
	 * 作用: 返回字符串格式的日期时间 --> yyyy-MM-dd HH:mm:ss
	 * 
	 * @return
	 */
	public String getNow() {
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return formatter.format(new Date());
	}

	// 把系统时间推迟或提前数分钟
	public String getNextMinute(int count) {
		Calendar c = Calendar.getInstance();
		c.add(Calendar.MINUTE, count);
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return formatter.format(c.getTime());
	}

	// 把系统时间推迟或提前数天
	public String getNextDay(int count) {
		Calendar c = Calendar.getInstance();
		c.add(Calendar.DAY_OF_MONTH, count);
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return formatter.format(c.getTime());
	}

	// 计算开始时间和结束时间方法
	public static JSONObject computeDate(int stairmonths) {
		String startDate;
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
		String endDate = formatter.format(new Date());

		Calendar cal = Calendar.getInstance();
		int year = Integer.parseInt(endDate.substring(0, 4));
		int month = Integer.parseInt(endDate.substring(5, 7));
		int day = Integer.parseInt(endDate.substring(8, 10));
		cal.set(year, month - 1, day);

		// 计算当前月在哪个阶梯区间
		// Calendar cal = Calendar.getInstance();
		// int thismonth = cal.get(Calendar.MONTH) + 1;
		int thismonth = cal.get(Calendar.MONTH);
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		if (stairmonths == 1) {
			cal.set(Calendar.DAY_OF_MONTH, 1);
			startDate = format.format(cal.getTime());
			cal.set(Calendar.DAY_OF_MONTH,
					cal.getActualMaximum(Calendar.DAY_OF_MONTH));
			endDate = format.format(cal.getTime());
		} else if (stairmonths == 0) {
			startDate = "";
			endDate = "";
		} else {
			/*
			 * 阶梯起始月数计算起始月 = 当前月/阶梯月数*阶梯月数+1结束月 = 当前月/阶梯月数*阶梯月数+阶梯月数注：该运算
			 * 当前月是12月时则需要剪1 上面已经算出阶梯月数为1个月时的金额一下运算阶梯月数至少为两个月 所以对算区间没有影响
			 */
			if (thismonth == 12) {
				thismonth = 11;
			}
			// 计算起始月
			int star = Math.round(thismonth / stairmonths) * stairmonths + 1;
			// 计算结束月
			int end = Math.round(thismonth / stairmonths) * stairmonths
					+ stairmonths;
			// 获得起始日期和结束日期
			cal.set(Calendar.MONTH, star - 1);
			cal.set(Calendar.DAY_OF_MONTH, 1);
			startDate = format.format(cal.getTime());
			cal.set(Calendar.MONTH, end - 1);
			cal.set(Calendar.DAY_OF_MONTH,
					cal.getActualMaximum(Calendar.DAY_OF_MONTH));
			endDate = format.format(cal.getTime());
		}
		JSONObject jo = new JSONObject();
		jo.put("startDate", startDate);
		jo.put("endDate", endDate);

		return jo;
	}

	public String format(String dt, String pattern) {
		try {
			Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dt);
			return new SimpleDateFormat(pattern).format(date);
		} catch (Exception e) {
			System.out.println("格式化日期字符串失败!");
			return null;
		}
	}

	// public static void main(String[] args) {
	// String s = new DatePlugin().format("2017-09-09 12:12:12",
	// "yyyyMMddHHmmss");
	// JSONObject jo = DatePlugin.computeDate(12);
	// System.out.println(jo);
	// }
}
