/*
 * Decompiled with CFR 0.152.
 */
package com.aote.report;

import com.aote.ThreadResource;
import com.aote.sql.SqlMapper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ReportMapper {
    static Logger log = Logger.getLogger(ReportMapper.class);
    private static Map<String, String> map;

    public static synchronized String getReport(String alias) {
        if (map == null) {
            ReportMapper.loadMap();
        }
        if (map.containsKey(alias)) {
            String result = ReportMapper.getReportByUser(alias);
            if (result != null) {
                return result;
            }
            return map.get(alias);
        }
        return null;
    }

    public static synchronized Map<String, String> getReport() {
        if (map == null) {
            ReportMapper.loadMap();
        }
        return map;
    }

    private static String getReportByUser(String alias) {
        String dir = (String)ThreadResource.ComponentDir.get();
        if (dir == null) {
            return null;
        }
        String path = "/" + dir + "/reports/" + alias + ".rpt.xml";
        if (ReportMapper.class.getResource(path) != null) {
            return path;
        }
        return null;
    }

    private static void loadMap() {
        map = new HashMap<String, String>();
        SAXReader reader = new SAXReader();
        InputStream input = SqlMapper.class.getClassLoader().getResourceAsStream("report.xml");
        try {
            Document document = reader.read(input);
            Element root = document.getRootElement();
            Iterator it = root.elementIterator("report");
            while (it.hasNext()) {
                Element elm = (Element)it.next();
                String alias = elm.attribute("alias").getValue();
                String path = elm.attribute("path").getValue();
                map.put(alias, path);
            }
        }
        catch (DocumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void main(String[] args) {
        ReportMapper.loadMap();
        for (String key : map.keySet()) {
            System.out.println(key);
        }
    }
}

