/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugin;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class NumberUtil {
    public static List<String> getNumberMark(String start, String count) {
        int s = Integer.parseInt(start);
        int c = Integer.parseInt(count);
        return NumberUtil.getNumberMark(s, c);
    }

    public static List<String> getNumberMark(int start, int count) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= count; ++i) {
            list.add(NumberUtil.getNumberFormat(start) + i);
        }
        return list;
    }

    public static String getNumberFormat(int num) {
        return String.format("%05d", num);
    }

    public static String seg(Object num) {
        if (num == null) {
            return "0";
        }
        String investPrice = NumberFormat.getCurrencyInstance().format(num);
        return investPrice.replace("\uffe5", "");
    }

    public static String isnull(Object num) {
        if (num == null) {
            return " ";
        }
        try {
            if (Double.parseDouble(num.toString()) == 0.0) {
                return " ";
            }
        }
        catch (Exception e) {
            return num.toString();
        }
        return num.toString();
    }

    public static String getValue(JSONArray array, int num, String key) {
        if (array == null || array.length() == 0) {
            return "";
        }
        JSONObject json = new JSONObject(array.get(num).toString());
        String result = json.getString(key) == null ? "" : json.get(key).toString();
        return result;
    }

    public static String isnull(Object num, String flag) {
        if (num == null) {
            return " ";
        }
        if (flag == null || flag.trim().isEmpty()) {
            return num.toString();
        }
        Pattern pattern = Pattern.compile("[0-9]*\\.?[0-9]+");
        Matcher isNum1 = pattern.matcher(num.toString());
        Matcher isNum2 = pattern.matcher(flag);
        if (isNum1.matches() && isNum2.matches() && Double.parseDouble(flag) == Double.parseDouble(num.toString())) {
            return " ";
        }
        if (!isNum1.matches() && !isNum2.matches() && num.toString().equals(flag)) {
            return " ";
        }
        return num.toString();
    }

    public static Double isNum(Object num, String flag) {
        if (num == null || num.toString().trim().isEmpty()) {
            if (flag == null || flag.equals("null")) {
                return null;
            }
            return 0.0;
        }
        Pattern pattern = Pattern.compile("[0-9]*\\.?[0-9]+");
        Matcher isNum = pattern.matcher(num.toString());
        if (isNum.matches()) {
            return Double.parseDouble(num.toString());
        }
        if (flag == null || flag.equals("null")) {
            return null;
        }
        return 0.0;
    }

    public static String getNumFor(int x, Object num) {
        if (num == null) {
            return "0";
        }
        DecimalFormat df1 = (DecimalFormat)DecimalFormat.getInstance();
        df1.setGroupingSize(x);
        return df1.format(Long.valueOf(num.toString()));
    }

    public static String getPercent(BigDecimal a, BigDecimal b) {
        BigDecimal c = new BigDecimal(0);
        if (a.compareTo(c) == 0 || b.compareTo(c) == 0) {
            return "0.00%";
        }
        BigDecimal d = a.divide(b, 2, 4);
        String s = d.toString();
        String perc = s.substring(2) + '%';
        return perc;
    }

    public static String numFormat(Object s, int inx) {
        StringBuffer m = new StringBuffer("0");
        for (int i = 0; i < inx; ++i) {
            if (i == 0) {
                m.append(".");
            }
            m.append("0");
        }
        if (s == null) {
            return m.toString();
        }
        if (s instanceof BigDecimal) {
            int flag = ((BigDecimal)s).compareTo(BigDecimal.ZERO);
            if (flag == 0) {
                return m.toString();
            }
            return s.toString();
        }
        Double d = Double.parseDouble(s.toString());
        if (d == 0.0) {
            return m.toString();
        }
        return d.toString();
    }

    public static String getPercent(int a, int b) {
        if (a == 0 || b == 0) {
            return "0.00%";
        }
        float num = (float)a / (float)b;
        DecimalFormat df = new DecimalFormat("0.00");
        String s = df.format(num);
        String ss = s.substring(2) + '%';
        return ss;
    }

    public static void main(String[] args) {
        System.out.println(NumberUtil.numFormat(0, 0));
    }
}

