/*
 * Decompiled with CFR 0.152.
 */
package com.aote.report;

import com.af.expression.Delegate;
import com.af.expression.Program;
import com.aote.report.Report;
import org.dom4j.Element;

public class Cell {
    public int row = 0;
    public int column = 0;
    public int rowSpan = 1;
    public int columnSpan = 1;
    public String css = "";
    public String width = "";
    public String height = "";
    public String content = "";
    public Delegate delegate;
    public Report report;

    public Cell(Element ele) {
        this.row = Integer.parseInt(ele.attributeValue("row"));
        this.column = Integer.parseInt(ele.attributeValue("column"));
        this.rowSpan = Integer.parseInt(ele.attributeValue("rowspan"));
        this.columnSpan = Integer.parseInt(ele.attributeValue("columnspan"));
        this.content = ele.attributeValue("content");
        this.css = ele.attributeValue("css");
        this.width = ele.attributeValue("width");
        this.height = ele.attributeValue("height");
    }

    public Cell(int row, int column, int rowSpan, int columnSpan, String content) {
        this.row = row;
        this.column = column;
        this.rowSpan = rowSpan;
        this.columnSpan = columnSpan;
        this.content = content;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public void compile() {
        if (this.content == null || this.content.trim().equals("")) {
            return;
        }
        Program prog = new Program(this.content);
        this.delegate = prog.parse();
    }

    public Object invoke() {
        if (this.delegate == null) {
            return "";
        }
        return this.delegate.invoke(this.report.vars);
    }

    public Cell clone() {
        Cell result = new Cell(this.row, this.column, this.rowSpan, this.columnSpan, this.content);
        if (this.width != null && !this.width.equals("")) {
            result.width = this.width;
        }
        if (this.height != null && !this.height.equals("")) {
            result.height = this.height;
        }
        if (this.css != null && !this.css.equals("")) {
            result.css = this.css;
        }
        if (this.delegate != null) {
            result.delegate = this.delegate;
        }
        if (this.report != null) {
            result.report = this.report;
        }
        return result;
    }

    public String toString() {
        return this.row + ":" + this.column;
    }
}

