package com.aote.plugin;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 * 对工单进行处理的插件，前后台都用
 */
public class ServicePlugin {
	private static Logger log = Logger.getLogger(ServicePlugin.class);

	// 根据前台传过来的一批工单编号，以及查询到的待办工单内容，返回新增工单/删除工单/修改工单结果
	// androids: 安卓端未完成的工单列表，JSON串, 格式: [{id: 安卓端id, id_back: pc端工单 id, service_version: 版本号}]
	// pcs: pc端查找到的未处理完的工单，JSON串， 格式：[{完整工单内容，service_version:版本号, 故障信息}]
	// 返回结果: json对象，格式 {inserts: [新增工单], deletes: [{id_back: 工单 id}], modifies: [修改工单]}
	public JSONObject getChanged(JSONArray androids, JSONArray pcs) {
		JSONArray inserts = new JSONArray();
		JSONArray deletes = new JSONArray();
		JSONArray modifies = new JSONArray();
		JSONObject result = new JSONObject();
		result.put("inserts", inserts);
		result.put("deletes", deletes);
		result.put("modifies", modifies);
		
		JSONArray noDeletes = new JSONArray();
		for (Object pcObj : pcs) {
			// 如果pc端工单不包含在安卓端，新增
			JSONObject pc = (JSONObject)pcObj;
			JSONObject android = this.getService(androids, "id_back", pc, "id");
			if (android == null) {
				inserts.put(pc);
			} else {
				// 否则，登记到不需删除中
				noDeletes.put(android);
				// 如果版本号发生变化，添加到修改里
				if (pc.getInt("service_version") != android.getInt("service_version")) {
					// 把新的工单内容返回，但id号及id_back必须维持平板端的
					pc.put("id", android.getInt("id"));
					pc.put("id_back", android.getInt("id_back"));
					modifies.put(pc);
				}
			}
		}
		
		// 安卓端工单去掉pc端已包含的，就是要删除的
		for (Object o : androids) {
			JSONObject android = (JSONObject)o;
			JSONObject json = this.getService(noDeletes, "id", android, "id");
			if (json == null) {
				deletes.put(android);
			}
		}
		
		return result;
	}
	
	/**
	 * 判断是否有新增
	 * @param oldjson 旧数据
	 * @param oldattr 旧数据匹配字段
	 * @param newjson 新数据
	 * @param newattr 新数据匹配字段 
	 */
	public Boolean isInsert(JSONArray oldjson, String oldattr, JSONArray newjson,String newattr ) {
		//默认没有新增
		Boolean result = false;
		//遍历新提取的数据
		for (Object newObj : newjson) {
			// 如果pc端工单不包含在安卓端，新增
			JSONObject pc = (JSONObject)newObj;
			//拿到其中一条和旧数据针对某一字段进行对比
			JSONObject data = this.getService(oldjson, oldattr, pc, newattr);
			//没有匹配到就说明有新数据
			if (data == null) {
				result = true;
			}
		}
		return result;
		
	}
	
	/**
	 * 获取工单列表中所有故障列表, 用于前台对故障id号进行清理
	 */
	public JSONArray getFailures(JSONArray services) {
		JSONArray result = new JSONArray();
		for(Object obj : services) {
			JSONObject service = (JSONObject)obj;
			if (service.has("failure")) {
				JSONArray failures = service.getJSONArray("failure");
				for (Object o : failures) {
					JSONObject failure = (JSONObject)o;
					result.put(failure);
				}
			}
		}
		return result;
	}
	
	/**
	 * 从工单集合中，获取与给定工单id相同的工单
	 * @param array 工单集合
	 * @param arrayId 工单集合里的工单id名
	 * @param json 要查看的工单
	 * @param jsonId 要查看的工单的id名 
	 * @return 工单集合里的工单，没有，返回空
	 */
	private JSONObject getService(JSONArray array, String arrayId, JSONObject json, String jsonId) {
		for(Object o : array) {
			JSONObject otherJson = (JSONObject)o;
			if (otherJson.getInt(arrayId) == json.getInt(jsonId)) {
				return otherJson;
			}
		}
		return null;
	}
}
