SELECT
	b.f_order_man AS name2,
	r.chulizhong,
	daiwancheng,
	todaywancheng AS todaywancheng,
	todaydaiwan AS todaydaiwan,
	f_longitude,
	f_latitude
FROM
	(
		SELECT
			f_order_man,
			chulizhong,
			SUM (daiwancheng) AS daiwancheng,
			SUM (todaywancheng) AS todaywancheng,
			SUM (todaydaiwan) AS todaydaiwan,
			SUM (f_longitude) AS f_longitude,
			SUM (f_latitude) AS f_latitude
		FROM
			(
				SELECT
					f_order_man,
					'' chulizhong,
					COUNT (*) AS daiwancheng,
					0 todaywancheng,
					0 todaydaiwan,
					0 f_longitude,
					0 f_latitude
				FROM
					t_service
				WHERE
					F_REPAIRMAN_STATE <> '维修完成'
				AND f_workorder_type = '报修单'
				AND 1 = 1
				GROUP BY
					f_order_man
				UNION ALL
					SELECT
						T_SERVICE.f_order_man,
						'' chulizhong,
						0 daiwancheng,
						COUNT (*) AS todaywancheng,
						0 todaydaiwan,
						0 f_longitude,
						0 f_latitude
					FROM
						T_SERVICE
					LEFT JOIN T_REPAIRMAN ON T_REPAIRMAN.F_SERVICE_ID = T_SERVICE.F_SERVICE_ID
					AND T_REPAIRMAN.F_REPAIRMAN_STATE = T_SERVICE.F_REPAIRMAN_STATE
					AND T_REPAIRMAN.F_ORDER_MAN = T_SERVICE.F_ORDER_MAN
					WHERE
						1 = 1
					AND TRUNC (
						SYSDATE - TO_DATE (
							TO_CHAR (
								F_OPERATE_DATE,
								'yyyy-MM-dd'
							),
							'yyyy-mm-dd'
						)
					) = 0
					AND t_repairman.F_REPAIRMAN_STATE = '维修完成'
					AND 1 = 1
					GROUP BY
						T_SERVICE.f_order_man
					UNION ALL
						SELECT
							T_SERVICE.f_order_man,
							'' chulizhong,
							0 daiwancheng,
							0 todaywancheng,
							COUNT (*) AS todaydaiwan,
							0 f_longitude,
							0 f_latitude
						FROM
							T_SERVICE
						LEFT JOIN T_REPAIRMAN ON T_REPAIRMAN.F_SERVICE_ID = T_SERVICE.F_SERVICE_ID
						AND T_REPAIRMAN.F_ORDER_MAN = T_SERVICE.F_ORDER_MAN
						WHERE
							TRUNC (
								SYSDATE - TO_DATE (
									TO_CHAR (
										F_OPERATE_DATE,
										'yyyy-MM-dd'
									),
									'yyyy-mm-dd'
								)
							) = 0
						AND T_REPAIRMAN.F_REPAIRMAN_STATE = '接单'
						AND 1 = 1
						GROUP BY
							T_SERVICE.f_order_man
						UNION ALL
							SELECT
								f_user_name AS f_order_man,
								'' chulizhong,
								0 daiwancheng,
								0 todaywancheng,
								0 todaydaiwan,
								CAST (f_longitude AS DECIMAL(10, 7)) AS f_longitude,
								CAST (f_latitude AS DECIMAL(10, 7)) AS f_latitude
							FROM
								t_phone_state
							WHERE
								f_period = '最新'
							AND 1 = 1
							GROUP BY
								f_user_name,
								f_longitude,
								f_latitude
			) A
		GROUP BY
			f_order_man,
			chulizhong
	) b
LEFT JOIN (
	SELECT
		T_REPAIRMAN.f_order_man,
		t_repairman.F_REPAIRMAN_STATE || T_REPAIRMAN.F_SERVICE_ID chulizhong
	FROM
		t_service
	LEFT JOIN (
		SELECT
			*
		FROM
			T_REPAIRMAN
		WHERE
			ID = ANY (
				SELECT
					MAX (ID)
				FROM
					T_REPAIRMAN
				GROUP BY
					F_SERVICE_ID
			)
		AND (
			t_repairman.F_REPAIRMAN_STATE = '开始维修'
			OR t_repairman.F_REPAIRMAN_STATE = '正在路上'
		)
	) t_repairman ON t_service.f_service_id = t_repairman.f_service_id
	WHERE
		1 = 1
	AND TRUNC (
		SYSDATE - TO_DATE (
			TO_CHAR (
				F_OPERATE_DATE,
				'yyyy-MM-dd'
			),
			'yyyy-mm-dd'
		)
	) = 0
	AND t_service.f_workorder_type = '报修单'
) r ON r.f_order_man = b.F_ORDER_MAN
WHERE
	{ condition }