package com.aote.plugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class GeoTransPlugin {

	public void transform(JSONArray locs, String url) throws Exception{
		for(int i= 0; i< locs.length(); i++) 
			transform(locs.getJSONObject(i), url);
	}
	
	private void transform(JSONObject loc, String url) throws Exception{
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader(HTTP.CONTENT_TYPE, "application/x-www-form-urlencoded;charset=UTF-8");
        List<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("wgs84Lng", loc.getString("f_longitude")));
        nameValuePairs.add(new BasicNameValuePair("wgs84Lat", loc.getString("f_latitude")));
        httpPost.setEntity(new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
        HttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute(httpPost);
        if(response.getStatusLine().getStatusCode() != 200) 
        	throw new IOException();
        String xml =  EntityUtils.toString(response.getEntity(), "UTF8");
        xml = xml.substring(xml.indexOf("\">", 0) + 2);
        xml = xml.substring(0,  xml.indexOf("</string>")).trim();
        String[] ll = xml.split("\\|");
        loc.put("f_longitude", ll[0]);
        loc.put("f_latitude", ll[1]);
	}
	
	public JSONObject getLLByPlumbId(String transUrl, String gisUrl) throws Exception{
		//先到地图服务取xy坐标
		JSONObject jo = fetchXY(gisUrl);
		//把xy坐标转换成wgs84
		reverse(jo, transUrl);
		return jo;
	}
	
	/**
	 * 转换小区xy坐标到经纬度
	 * @return
	 * @throws Exception
	 */
	public JSONObject convertLLFromAreaXY(String transUrl, String x, String y) throws Exception{
		JSONObject jo = new JSONObject();
		jo.put("x", x);
		jo.put("y", y);
		//把xy坐标转换成wgs84
		reverse(jo, transUrl);
		return jo;
	}
	
	private JSONObject fetchXY(String gisUrl) throws Exception {
		HttpGet httpGet = new HttpGet(gisUrl);
        HttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute(httpGet);
        if(response.getStatusLine().getStatusCode() != 200) 
        	throw new IOException();
        String r =  EntityUtils.toString(response.getEntity(), "UTF8");
        JSONObject jo = new JSONObject(r).getJSONArray("features").getJSONObject(0);
		return jo;
	}
	
	private void reverse(JSONObject loc, String transUrl) throws Exception{
        HttpPost httpPost = new HttpPost(transUrl);
        httpPost.setHeader(HTTP.CONTENT_TYPE, "application/x-www-form-urlencoded;charset=UTF-8");
        List<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("localX", loc.getString("x")));
        nameValuePairs.add(new BasicNameValuePair("localY", loc.getString("y")));
        httpPost.setEntity(new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
        HttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute(httpPost);
        if(response.getStatusLine().getStatusCode() != 200) 
        	throw new IOException();
        String xml =  EntityUtils.toString(response.getEntity(), "UTF8");
        xml = xml.substring(xml.indexOf("\">", 0) + 2);
        xml = xml.substring(0,  xml.indexOf("</string>")).trim();
        String[] ll = xml.split("\\|");
        loc.put("f_longitude", ll[0]);
        loc.put("f_latitude", ll[1]);
	}
	
}
