package com.aote.job;

import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class PatrolFormJob {
	private static Logger log = Logger.getLogger(PatrolFormJob.class);
	
	private HashMap<String, String> map;
	private String logic;
	private String patrolUrl;
	private String ccurl;

	public void run() throws Exception{
		String lastFormFoundTime = findLastFormFoundTime();
		
		JSONArray rows = fetchPatrolFormByTimestamp(lastFormFoundTime);
		if(rows.length() > 0) {
			log.debug("提取到数据条数:" + rows.length());
			normalize(rows);
			//运行定时提取逻辑
			for(int i = 0; i < rows.length(); i++) {
				runlogic(rows.getJSONObject(i));
			}
			updateParam();
		}
	}
	
	private void updateParam() throws Exception {
		String path= ccurl + "rs/logic/update";
		String body = "{data: {tablename:\"t_singlevalue\", condition: \" name='patrolTimestamp'\", "
				+ "parameters: {value: \"" + standardDatetime() + "\"}}}";
		// POSTMethod
		HttpPost postMethod =new HttpPost(path);
		StringEntity se = new StringEntity(body, "UTF-8");
		postMethod.setEntity(se);
		// 发送Post请求
		HttpClient httpClient = new DefaultHttpClient();
		HttpResponse response = httpClient.execute(postMethod);
		int code = response.getStatusLine().getStatusCode();
		// 如果成功
		if (code != 200) {
			throw new RuntimeException("返回值错误：" + code + "\npath: " + path + "\nbody:" + body);
		}
	}

	private void runlogic(JSONObject row) throws Exception {
		String path= ccurl + "rs/logic/" + logic;
		String body = "{\"data\":" + row + "}";
		// POSTMethod
		HttpPost postMethod =new HttpPost(path);
		StringEntity se = new StringEntity(body, "UTF-8");
		postMethod.setEntity(se);
		// 发送Post请求
		HttpClient httpClient = new DefaultHttpClient();
		HttpResponse response = httpClient.execute(postMethod);
		int code = response.getStatusLine().getStatusCode();
		// 如果不成功
		if (code != 200) {
			throw new RuntimeException("返回值错误：" + code + "\npath: " + path + "\nbody:" + body);
		}
	}

	private String standardDatetime() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return sdf.format(new Date());
	}
	
	private void normalize(JSONArray rows) {
		for(int i=0; i< rows.length(); i++) {
			JSONObject unknwn = rows.getJSONObject(i);
			Set<String> set = unknwn.keySet();
			String[] keys = set.toArray(new String[0]);
			for(String key : keys) {
				if(map.containsKey(key)) {
					String value = unknwn.getString(key);
					unknwn.remove(key);
					unknwn.put(map.get(key), value);
				}
			}
		}
	}
		

	private JSONArray fetchPatrolFormByTimestamp(String ts) throws ParseException, IOException {
        @SuppressWarnings("deprecation")
		HttpGet httpGet = new HttpGet(patrolUrl + URLEncoder.encode(ts).replace("+", "%20"));
        HttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute(httpGet);
        if(response.getStatusLine().getStatusCode() != 200) 
        	throw new IOException();
        String xml =  EntityUtils.toString(response.getEntity(), "UTF8");
        xml = xml.substring(xml.indexOf("\">", 0) + 2);
        xml = xml.substring(0,  xml.indexOf("</string>")).trim();
        return new JSONArray(xml);
	}

	private String findLastFormFoundTime() throws Exception {
			String path= ccurl + "rs/sql/singleTable";
			String body = "{data: {tablename:\"t_singlevalue\", condition: \" name='patrolTimestamp'\"}}";
			// POSTMethod
			HttpPost postMethod =new HttpPost(path);
			StringEntity se = new StringEntity(body, "UTF-8");
			postMethod.setEntity(se);
			// 发送Post请求
			HttpClient httpClient = new DefaultHttpClient();
			HttpResponse response = httpClient.execute(postMethod);
			int code = response.getStatusLine().getStatusCode();
			// 如果成功
			if (code == 200) {
				String actual = EntityUtils.toString(response.getEntity(), "UTF8");
				JSONArray rows = new JSONArray(actual);
				return rows.getJSONObject(0).getString("value");
			} else {
				throw new RuntimeException("返回值错误：" + code + "\npath: " + path + "\nbody:" + body);
			}
	}
	
	public String getLogic() {
		return logic;
	}

	public void setLogic(String logic) {
		this.logic = logic;
	}

	public String getPatrolUrl() {
		return patrolUrl;
	}

	public void setPatrolUrl(String patrolUrl) {
		this.patrolUrl = patrolUrl;
	}

	public String getCcurl() {
		return ccurl;
	}

	public void setCcurl(String ccurl) {
		this.ccurl = ccurl;
	}

	public HashMap<String, String> getMap() {
		return map;
	}

	public void setMap(HashMap<String, String> map) {
		this.map = map;
	}
}
