SELECT
	SUM (phoneTotal) AS phoneTotal,
	SUM (quickTotal) AS quickTotal,
	SUM (iniletotal) AS iniletotal
FROM
	(
		SELECT
			COUNT (OUTLTIME) AS phoneTotal,
			0 quickTotal,
			0 iniletotal
		FROM
			t_records
		WHERE
			TO_DATE (
				OUTLTIME,
				'yyyy-mm-dd hh24:mi:ss'
			) >= TRUNC (SYSDATE)
		UNION ALL
			SELECT
				0 phoneTotal,
				COUNT (OUTLTIME) AS quickTotal,
				0 iniletotal
			FROM
				t_records
			WHERE
				(
					TO_NUMBER (
						TO_DATE (
							STARTTIME,
							'yyyy-mm-dd hh24:mi:ss'
						) - TO_DATE (
							INLTIME,
							'yyyy-mm-dd hh24:mi:ss'
						)
					) * 24 * 60 * 60 <= 15
				)
			AND STARTTIME IS NOT NULL
			AND INLTIME IS NOT NULL
			AND TO_DATE (
				OUTLTIME,
				'yyyy-mm-dd hh24:mi:ss'
			) >= TRUNC (SYSDATE)
			UNION ALL
				SELECT
					0 phoneTotal,
					0 quickTotal,
					COUNT (OUTLTIME) AS iniletotal
				FROM
					t_records
				WHERE
					STARTTIME IS NOT NULL
				AND TO_DATE (
					OUTLTIME,
					'yyyy-mm-dd hh24:mi:ss'
				) >= TRUNC (SYSDATE)
	)