/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugin;

import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class InformPlugin {
    private static Logger log = Logger.getLogger(InformPlugin.class);
    public static String removeInformUrl = "http://192.168.2.54/WebSiteWarm/API/Del/DropMessage";

    public void confirm(JSONObject params, SqlServer sql) throws Exception {
        JSONArray rows = this.getAllNotifierRelated(params.getString("notifId"), sql);
        for (int i = 0; i < rows.length(); ++i) {
            JSONObject row = rows.getJSONObject(0);
            String id = row.getInt("id") + "";
            this.removeNotifier(removeInformUrl, id);
            sql.runSQL("delete from t_notifier where id=" + id);
        }
    }

    public String inform(JSONObject params, JSONArray undos, SqlServer sql, EntityServer entity) {
        try {
            String guid;
            JSONObject undo;
            int i;
            if (undos.length() == 0) {
                return null;
            }
            String addNotifierUrl = params.getString("addNotifierUrl");
            String updateNotifierUrl = params.getString("updateNotifierUrl");
            JSONObject activities = params.getJSONObject("activities");
            JSONObject urls = params.getJSONObject("urls");
            JSONObject corUrls = params.getJSONObject("corUrls");
            JSONObject modules = params.getJSONObject("modules");
            HashMap<String, String> guids = new HashMap<String, String>();
            String strids = "";
            int maxId = 0;
            HashMap<String, String> hints = new HashMap<String, String>();
            HashMap activityUserStatMap = new HashMap();
            Iterator itr = activities.keys();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                String value = activities.getString(key);
                hints.put(key, value);
                activityUserStatMap.put(key, new HashMap());
            }
            for (i = 0; i < undos.length(); ++i) {
                JSONObject group;
                undo = undos.getJSONObject(i);
                int id = undo.getInt("id");
                maxId = maxId < id ? id : maxId;
                String activity = undo.getString("defname");
                if (!hints.containsKey(activity) || !undo.has("actor") || !(group = undo.getJSONObject("actor")).has("f_person")) continue;
                JSONArray executors = group.getJSONArray("f_person");
                for (int j = 0; j < executors.length(); ++j) {
                    JSONObject operator = executors.getJSONObject(j);
                    String userid = operator.getString("userid");
                    if (guids.containsKey(userid)) continue;
                    guids.put(userid, null);
                    strids = strids + "'" + userid + "' ,";
                }
            }
            if (strids.length() == 0) {
                return null;
            }
            this.findAndFillGuids(guids, strids.substring(0, strids.length() - 1), sql);
            for (i = 0; i < undos.length(); ++i) {
                JSONObject group;
                undo = undos.getJSONObject(i);
                String activity = undo.getString("defname");
                if (!hints.containsKey(activity) || !undo.has("actor") || !(group = undo.getJSONObject("actor")).has("f_person")) continue;
                JSONArray executors = group.getJSONArray("f_person");
                for (int j = 0; j < executors.length(); ++j) {
                    Stat stat;
                    JSONObject operator = executors.getJSONObject(j);
                    String userid = operator.getString("userid");
                    guid = guids.get(userid);
                    if (guid == null) continue;
                    HashMap aus = (HashMap)activityUserStatMap.get(activity);
                    if (!aus.containsKey(userid)) {
                        stat = new Stat();
                        stat.guid = guid;
                        stat.cnt = 1;
                        stat.actor = group.getString("id");
                        aus.put(userid, stat);
                        continue;
                    }
                    stat = (Stat)aus.get(userid);
                    ++stat.cnt;
                    aus.put(userid, stat);
                }
            }
            Set msgTypes = activityUserStatMap.keySet();
            for (String msgType : msgTypes) {
                HashMap userMap = (HashMap)activityUserStatMap.get(msgType);
                Set users = userMap.keySet();
                for (String user : users) {
                    Stat stat = (Stat)userMap.get(user);
                    guid = stat.guid;
                    if (guid == null) continue;
                    int cnt = stat.cnt;
                    String actor = stat.actor;
                    String mt = (String)hints.get(msgType);
                    String notifierId = this.getNotifierId(mt, actor, user, guid, sql);
                    String cosUrl = corUrls.getString("fallback") + "?type=station";
                    String url = urls.getString("fallback") + "?type=station";
                    String module = modules.getString("fallback");
                    if (corUrls.has(actor)) {
                        cosUrl = corUrls.getString(actor) + "?type=monitor";
                    }
                    if (urls.has(actor)) {
                        url = urls.getString(actor) + "?type=monitor";
                    }
                    if (modules.has(actor)) {
                        module = modules.getString(actor);
                    }
                    if (notifierId == null) {
                        this.addBothNotifier(addNotifierUrl, mt, actor, user, guid, cnt, url, cosUrl, module, sql, entity);
                        continue;
                    }
                    this.updateBothNotifier(updateNotifierUrl, notifierId, mt, actor, user, guid, cnt, url, cosUrl, module, sql, entity);
                }
            }
            return maxId + "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void updateBothNotifier(String url, String notifierId, String msgType, String actor, String user, String guid, int cnt, String redirect, String corUrl, String module, SqlServer sql, EntityServer entity) throws Exception {
        JSONObject jo = new JSONObject();
        String content = msgType + "\u4e2a\u6570: " + cnt;
        jo.put("id", Integer.parseInt(notifierId));
        jo.put("activity", (Object)msgType);
        jo.put("actor", (Object)actor);
        jo.put("f_user_guid", (Object)guid);
        jo.put("f_user_id", (Object)user);
        jo.put("f_msg_cnt", cnt);
        jo.put("f_title", (Object)msgType);
        jo.put("f_content", (Object)msgType);
        jo.put("f_redirect_url", (Object)content);
        jo.put("f_status", (Object)"placeholder");
        entity.partialSave("t_notifier", jo);
        corUrl = corUrl + "?notifId=" + notifierId;
        redirect = redirect + "?notifId=" + notifierId;
        this.updateNotifier(url, guid, notifierId, msgType, content, redirect, corUrl, "placeholder", module);
    }

    private void addBothNotifier(String url, String msgType, String actor, String user, String guid, int cnt, String redirect, String corUrl, String module, SqlServer sql, EntityServer entity) throws Exception {
        JSONObject jo = new JSONObject();
        String content = msgType + "\u4e2a\u6570: " + cnt;
        jo.put("activity", (Object)msgType);
        jo.put("actor", (Object)actor);
        jo.put("f_user_guid", (Object)guid);
        jo.put("f_user_id", (Object)user);
        jo.put("f_msg_cnt", cnt);
        jo.put("f_title", (Object)msgType);
        jo.put("f_content", (Object)content);
        jo.put("f_redirect_url", (Object)redirect);
        jo.put("f_status", (Object)"placeholder");
        String id = new JSONObject(entity.partialSave("t_notifier", jo)).getString("id");
        corUrl = corUrl + "&notifId=" + id;
        redirect = redirect + "&notifId=" + id;
        this.addNotifier(url, guid, id, msgType, content, redirect, corUrl, "placeholder", module);
    }

    private String getNotifierId(String actor, String msgType, String user, String guid, SqlServer sql) throws Exception {
        JSONObject jo = new JSONObject();
        jo.put("items", (Object)"id");
        jo.put("tablename", (Object)"t_notifier");
        jo.put("condition", (Object)("f_user_id='" + user + "'" + " and f_title = '" + msgType + "'" + " and actor = '" + actor + "'" + " and activity = '" + msgType + "'" + " and f_user_guid='" + guid + "'"));
        JSONArray rows = sql.query("querySingleTable", jo);
        if (rows.length() == 0) {
            return null;
        }
        String id = rows.getJSONObject(0).getInt("id") + "";
        return id;
    }

    private JSONArray getAllNotifierRelated(String id, SqlServer sql) throws Exception {
        JSONObject jo = new JSONObject();
        jo.put("items", (Object)"a.id");
        jo.put("tablename", (Object)("t_notifier a, (select * from t_notifier where id=" + id + ") b"));
        jo.put("condition", (Object)"a.actor = b.actor and a.activity = b.activity");
        return sql.query("querySingleTable", jo);
    }

    private void findAndFillGuids(HashMap<String, String> guids, String strids, SqlServer sql) throws Exception {
        JSONObject jo = new JSONObject();
        jo.put("items", (Object)"name, f_name");
        jo.put("tablename", (Object)"t_user");
        jo.put("condition", (Object)("name in (" + strids + ")"));
        JSONArray users = sql.query("querySingleTable", jo);
        for (int i = 0; i < users.length(); ++i) {
            JSONObject user = users.getJSONObject(i);
            String name = user.getString("name");
            if (!guids.containsKey(name)) continue;
            if (user.isNull("f_name")) {
                log.debug((Object)("\u672a\u67e5\u627e\u5230\u91d1\u5efa\u7528\u6237" + name));
                continue;
            }
            log.debug((Object)("\u67e5\u627e\u5230\u91d1\u5efa\u7528\u6237" + name + ", id:" + user.getString("f_name")));
            guids.put(name, user.getString("f_name"));
        }
    }

    public boolean addNotifier(String addNotifierUrl, String userGuid, String notifierId, String title, String content, String redirectUrl, String corUrl, String status, String module) throws Exception {
        String body = "{\"str\":\"{'userguid':'%s','msgtype':'%s','status':'%s','httpurl':'%s', 'cosurl':'%s', 'title':'%s','contentstr':'%s','bussinesid': '%s', 'wintitle':'%s'}\"}";
        HttpPost httpPost = new HttpPost(addNotifierUrl);
        body = String.format(body, userGuid, "2", status, redirectUrl, corUrl, title, content, notifierId, module);
        log.debug((Object)("\u6dfb\u52a0\u901a\u77e5\u8bf7\u6c42\uff1a" + addNotifierUrl + "\n\u8bf7\u6c42\u4f53\uff1a" + body));
        httpPost.setHeader("Content-Type", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        int sc = response.getStatusLine().getStatusCode();
        if (sc != 200) {
            log.debug((Object)("\u72b6\u6001\u7801\uff1a" + sc));
            throw new IOException();
        }
        String s = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
        return s.equals("\"1\"");
    }

    public boolean updateNotifier(String updateNotifierUrl, String userGuid, String notifierId, String title, String content, String redirectUrl, String corUrl, String status, String module) throws Exception {
        return this.addNotifier(updateNotifierUrl, userGuid, notifierId, title, content, redirectUrl, corUrl, status, module);
    }

    public boolean removeNotifier(String removeNotifierUrl, String notifierId) throws Exception {
        String body = "{\"str\":\"{'msgtype':'%s','bussinesid': '%s'}\"}";
        HttpPost httpPost = new HttpPost(removeNotifierUrl);
        body = String.format(body, "2", notifierId);
        log.debug((Object)("\u79fb\u9664\u901a\u77e5\u8bf7\u6c42\uff1a" + removeNotifierUrl + "\n\u8bf7\u6c42\u4f53\uff1a" + body));
        httpPost.setHeader("Content-Type", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        int sc = response.getStatusLine().getStatusCode();
        if (sc != 200) {
            log.debug((Object)("\u72b6\u6001\u7801\uff1a" + sc));
            throw new IOException();
        }
        String s = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
        return s.equals("\"1\"");
    }

    private class Stat {
        public String guid;
        public int cnt;
        public String actor;

        private Stat() {
        }
    }
}

