package com.aote.rs;

import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 根据gis编号生成停复气计划
 */
@Path("createPlan")
@Component
@Transactional
public class CreatePlan {
    static Logger log = Logger.getLogger(CreatePlan.class);
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private SqlServer sqlServer;


    @POST
    @Produces(MediaType.APPLICATION_JSON)
    public JSONObject create(String str) {
        log.debug("生成停复气计划参数=====>"+str);
        JSONObject result = new JSONObject();
        try {
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat  simpleDateFormat= new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat  simpleDateFormat1= new SimpleDateFormat("yyyy-MM-dd");
            String year = cal.get(Calendar.YEAR) +"";
            String mounth = (cal.get(Calendar.MONTH) +1) +"";
            String [] arr = str.split(",");
            JSONArray items = new JSONArray();
            for (String anArr : arr) {
                log.debug("anArr"+anArr);
                JSONArray jsonArray = sqlServer.query("select f_serial_num from t_regulator_files where f_gis_id = '" + anArr +"'");
                if(jsonArray.length()>0){
                    JSONObject json = jsonArray.getJSONObject(0);
                    items.put(json);
                }
            }
            JSONObject data = new JSONObject();
            if(items.length() == 0){
                result.put("state","fail");
                result.put("reason","该批gis编号无对应调压箱");
                return result;
            }
            data.put("f_item",items);
            data.put("f_plan_id",CreateUUID.getUUID());
            data.put("f_plan_year",year);
            data.put("f_creater","gis生成");
            data.put("f_plan_month",mounth);
            data.put("f_plan_name",  simpleDateFormat1.format(new Date())+ "停复气计划");
            data.put("f_plan_type", "停复气");
            data.put("f_is_issue", "否");
            data.put("f_create_time",simpleDateFormat.format(new Date()));

            logicServer.run("create_task_checkplan",data);
            result.put("state","success");
            result.put("reason","生成计划成功");
            return result;
        }catch (Exception e) {
            e.printStackTrace();
            result.put("state","fail");
            result.put("reason","调用接口出错");
            return result;
        }

    }

}
