package com.aote.rs;

import org.json.JSONObject;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;

/**
 * 抄表插件
 *
 */

public class ReadMeterUtil {

    /**
     * 判断两个json中值是否相同
     * 用于档案变更时记录有变化的字段
     * @param jo1 新值
     * @param jo2 旧值
     * @return 判断结果,true: 有改变,false: 无改变
     */
    public static boolean isValueEquals(JSONObject jo1, JSONObject jo2, String s) {
        String newValue = jo1.optString(s);
        String oldValue = jo2.optString(s);
        try {
            BigDecimal newBigDecimal = new BigDecimal(newValue);
            BigDecimal oldBigDecimal = new BigDecimal(oldValue);
            return newBigDecimal.compareTo(oldBigDecimal) != 0;
        } catch (Exception e) {
            return !newValue.equals(oldValue);
        }

    }

}
