SELECT
    *
FROM
    (
        SELECT
            h.*,
            h1.*,
            hd.f_stair1amount,
            hd.f_stair1price,
            hd.f_stair1fee,
            hd.f_stair2amount,
            hd.f_stair2price,
            hd.f_stair2fee,
            hd.f_stair3amount,
            hd.f_stair3price,
            hd.f_stair3fee,
            hd.f_cycleamount,
            hd.f_cyclefee,
            hd.f_cycleprice,
            ua.f_zones
        FROM
            t_handplan h
                LEFT JOIN (
                SELECT
                    f_hand_id f_hand_id,
                    SUM ( CASE f_price_name WHEN '跨周期气价' THEN f_gas END ) f_cycleamount,
                    SUM ( CASE f_price_name WHEN '跨周期气价' THEN f_price END ) f_cycleprice,
                    SUM ( CASE f_price_name WHEN '跨周期气价' THEN f_money END ) f_cyclefee,
                    SUM ( CASE f_price_name WHEN '阶梯1' THEN f_gas WHEN '固定气价' THEN f_gas ELSE 0 END ) f_stair1amount,
                    SUM ( CASE f_price_name WHEN '阶梯1' THEN f_price WHEN '固定气价' THEN f_price ELSE 0 END ) f_stair1price,
                    SUM ( CASE f_price_name WHEN '阶梯1' THEN f_money WHEN '固定气价' THEN f_money ELSE 0 END ) f_stair1fee,
                    SUM ( CASE f_price_name WHEN '阶梯2' THEN f_gas ELSE 0 END ) f_stair2amount,
                    SUM ( CASE f_price_name WHEN '阶梯2' THEN f_price ELSE 0 END ) f_stair2price,
                    SUM ( CASE f_price_name WHEN '阶梯2' THEN f_money ELSE 0 END ) f_stair2fee,
                    SUM ( CASE f_price_name WHEN '阶梯3' THEN f_gas ELSE 0 END ) f_stair3amount,
                    SUM ( CASE f_price_name WHEN '阶梯3' THEN f_price ELSE 0 END ) f_stair3price,
                    SUM ( CASE f_price_name WHEN '阶梯3' THEN f_money ELSE 0 END ) f_stair3fee
                FROM
                    t_chargeprice
                WHERE
                    f_hand_id IS NOT NULL
                GROUP BY
                    f_hand_id
            ) hd ON hd.f_hand_id= h.id
                LEFT JOIN ( SELECT f_hand_id, SUM ( f_charge_money ) f_charge_money, SUM ( f_debt_money ) f_debt_money FROM t_sellinghand WHERE f_state = '有效' GROUP BY f_hand_id ) h1 ON h.id = h1.f_hand_id
                LEFT JOIN ( SELECT f_slice_area AS f_zones, f_userinfo_id FROM t_user_address ) ua ON h.f_userinfo_id= ua.f_userinfo_id
    ) t
WHERE
    { condition }
ORDER BY
    f_hand_date DESC
