select h.*,
       ui.f_user_phone,
       ad.f_residential_area,
       ad.f_building,
       ad.f_unit,
       ad.f_floor,
       ad.f_room,
       uf.f_adjustable_id,
       ui.f_rent_phone,
       ui.f_user_level,
       uf.f_last_gas,
       ui.f_book_no,
       uf.f_capacity,
       uf.f_input_person,
       uf.f_total_gas,
       uf.f_total_fee,
       ui.f_olduserinfo_code,
       ad.f_enter_number,
       uf.f_bqf_state
from (select id,
             f_meter_classify,
             f_tablebase,
             f_last_input_date,
             f_last_tablebase,
             f_userinfo_code,
             f_inputtor,
             f_hand_date,
             f_last_hand_date,
             f_input_date,
             f_meter_state,
             f_operator,
             f_filialeids,
             f_filiale,
             f_outlets,
             f_price_id,
             f_user_id,
             f_user_name,
             f_user_type,
             f_balance,
             f_gasproperties,
             f_userinfo_id,
             f_address,
             f_meter_brand,
             f_meter_style,
             f_meternumber,
             f_meter_book_num,
             f_meter_book_sort,
             f_book_name,
             f_hand_state,
             f_userfiles_id,
             f_notified_path,
             f_sign_path,
             f_result_state,
             f_price,
             f_comments,
             f_orgid,
             f_orgname,
             f_depid,
             f_depname,
             f_operatorid
      from t_cardhand
      where f_inputtor = '{f_inputtor}'
        and SUBSTRING(CONVERT(varchar, f_hand_date, 23), 0, 5) = year(getdate())
        and f_meter_state = '未抄表'
        and f_hand_state = '有效') h
         left join
     (select f_user_level, f_rent_phone, f_comments, f_userinfo_id, f_olduserinfo_code, f_book_no, f_user_phone
      from t_userinfo
      where f_user_state = '正常') ui on h.f_userinfo_id = ui.f_userinfo_id
         left join t_userfiles uf on h.f_userfiles_id = uf.f_userfiles_id
         left join t_gasmodel gm on uf.f_gasmodel_id = gm.id
         left join (select *
                    from t_stairprice
                    where f_state = '有效'
                      and f_price_type = '固定气价'
                      and getdate() >= f_perform_date
                      and getdate() <= f_end_date) sp on uf.f_price_id = sp.f_price_id
         LEFT JOIN t_detailprice dp ON sp.id = dp.f_stairprice_id and dp.f_price_name = '1'
         left join (select f_userinfo_id ad_userinfo_id,
                           f_residential_area,
                           f_building,
                           f_unit,
                           f_floor,
                           f_enter_number,
                           f_room
                    from t_user_address) ad on h.f_userinfo_id = ad.ad_userinfo_id
order by h.id desc
