SELECT * FROM (
	SELECT
	h.id,
	u.f_user_name,
	u.f_user_phone,
	A.f_address,
	f.f_meter_classify,
	--A.f_area,   --V3的最新user_address表里面没有f_area字段
	A.f_residential_area,
    u.f_balance,
	CASE WHEN h.f_last_tablebase IS NULL THEN f.f_meter_base
	ELSE f_last_tablebase END f_last_tablebase,
	h.f_last_lcd,
	h.f_meter_brand,
	f.f_user_id,
	f.f_meternumber,
	u.f_userinfo_id,
	u.f_userinfo_code,
	h.f_hand_date,
	h.f_operator,
	h.f_input_date,
	h.f_tablebase,
	h.f_filialeids,
	h.f_whether_pay,
	h.f_oughtamount,
	h.f_oughtfee,
	h.f_surplus_gas,
	h.f_haircut_gas,
	h.f_share_gas,
	h.f_inputtor,
	h.f_hand_state,
	A.f_building,
	A.f_unit,
	A.f_floor,
	A.f_room,
	ISNULL(h.f_meter_source, '手动录入') f_meter_source,
	ISNULL(h.f_issued_state, '手动下发') f_issued_state,
	ISNULL(h.f_meter_state,'未下发') f_meter_state
	FROM (SELECT MAX(f_hand_date) f_hand_date,f_user_id FROM t_handplan
	WHERE f_meter_state = '未抄表' and f_hand_state = '有效'
	GROUP BY f_user_id) t
	LEFT JOIN t_handplan h ON t.f_hand_date = h.f_hand_date
	AND t.f_user_id = h.f_user_id
	LEFT JOIN t_userinfo u ON u.f_userinfo_id = h.f_userinfo_id
	LEFT JOIN t_user_address A ON A.f_userinfo_id = u.f_userinfo_id
	LEFT JOIN t_userfiles f ON t.f_user_id = f.f_user_id
) a
where {condition}
order by f_user_id
