select * from (
    select
            f_user_name,
            f_userinfo_code,
            f_address,
            f_inputtor,
			f_balance,
            f_last_tablebase,
            f_tablebase,
            f_oughtamount,
			f_meternumber,
			f_meter_classify,
            f_oughtfee,
            convert(VARCHAR(100),f_input_date,23) f_input_date,
            convert(VARCHAR(100),f_last_input_date,23) f_last_input_date,
            f_last_oughtfee,
            case when f_last_oughtfee+f_oughtfee-f_balance>=0 then f_last_oughtfee+f_oughtfee-f_balance
            else 0 end f_oughtfee_all,
            f_stair1amount,
            f_stair2amount,
            f_stair3amount,
            f_stair1price,
            f_stair2price,
            f_stair3price,
            f_stair1fee,
            f_stair2fee,
            f_stair3fee
     from(
        select
            h.id,
            f_user_name,
            f_userinfo_code,
            f_address,
			h.f_balance,
			h.f_meternumber,
			h.f_meter_classify,
            f_inputtor,
            f_last_tablebase,
            f_tablebase,
            f_oughtamount,
            h.f_oughtfee,
            f_input_date,
            h1.f_last_input_date,
            (
                select sum(f_oughtfee) f_oughtfee from(
                select sum(f_oughtfee)-isnull(sum(f_debt_money),0) f_oughtfee
                from t_handplan left join (
                    select f_hand_id,sum(f_debt_money) f_debt_money from t_sellinghand
                    where f_operate_date < h.f_input_date
                    group by f_hand_id
                ) sh on id=sh.f_hand_id
                where f_input_date < h.f_input_date and f_userfiles_id=h.f_userfiles_id
                and f_meter_state='已抄表' and f_hand_state='有效' and f_whether_pay='否'
                union all
                select isnull(sum(f_debt_money),0) f_oughtfee from t_handplan left join (
                    select f_hand_id,sum(f_debt_money) f_debt_money from t_sellinghand
                    where f_operate_date > h.f_input_date
                    group by f_hand_id
                ) sh on id=sh.f_hand_id
                where f_input_date < h.f_input_date and f_meter_state='已抄表' and f_hand_state='有效' and f_whether_pay='是' and f_userfiles_id=h.f_userfiles_id
                ) p
            ) f_last_oughtfee
        from t_handplan h left join (
            select f_userfiles_id,max(f_input_date) f_last_input_date from t_handplan where
            f_meter_state='已抄表' and f_hand_state='有效' and  id < {id}
            group by f_userfiles_id
        ) h1 on h.f_userfiles_id=h1.f_userfiles_id
        where id = {id}
    ) h
    LEFT JOIN (
            SELECT
            f_hand_id f_hand_id,
            SUM ( CASE f_price_name WHEN '阶梯1' THEN f_gas WHEN '固定气价' THEN f_gas ELSE 0 END ) f_stair1amount,
            SUM ( CASE f_price_name WHEN '阶梯1' THEN f_price WHEN '固定气价' THEN f_price ELSE 0 END ) f_stair1price,
            SUM ( CASE f_price_name WHEN '阶梯1' THEN f_money WHEN '固定气价' THEN f_money ELSE 0 END ) f_stair1fee,
            SUM ( CASE f_price_name WHEN '阶梯2' THEN f_gas ELSE 0 END ) f_stair2amount,
            SUM ( CASE f_price_name WHEN '阶梯2' THEN f_price ELSE 0 END ) f_stair2price,
            SUM ( CASE f_price_name WHEN '阶梯2' THEN f_money ELSE 0 END ) f_stair2fee,
            SUM ( CASE f_price_name WHEN '阶梯3' THEN f_gas ELSE 0 END ) f_stair3amount,
            SUM ( CASE f_price_name WHEN '阶梯3' THEN f_price ELSE 0 END ) f_stair3price,
            SUM ( CASE f_price_name WHEN '阶梯3' THEN f_money ELSE 0 END ) f_stair3fee
    FROM
        t_chargeprice
    WHERE
        f_hand_id = {id}
    GROUP BY
        f_hand_id
        ) hd ON h.id= hd.f_hand_id
)t
