package com.aote.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;

import java.io.FileOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.github.junrar.Archive;
import org.apache.log4j.Logger;

public class Uncompress {
    Logger log = Logger.getLogger(Uncompress.class);
    //private String coding = "GBK";
    private String coding = null;

    public void uncompress(String source, String dest) {
        source = source.trim().replace("\\", "/").replace("/", File.separator);
        dest = dest.trim().replace("\\", "/").replace("/", File.separator);
        log.debug("----开始解压文件 ：" + source);
        if (source.toLowerCase().endsWith("zip")) {
            zip(source, dest);
        } else if (source.toLowerCase().endsWith("rar")) {
            rar(source, dest);
        }
        log.debug("----解压完成，到 ：" + dest);
    }

    public void uncompressCodingZip(String source, String dest, String coding) {
        source = source.trim().replace("\\", "/").replace("/", File.separator);
        dest = dest.trim().replace("\\", "/").replace("/", File.separator);
        log.debug("----开始解压文件 ：" + source);
        this.coding = coding;
        if (source.toLowerCase().endsWith("zip")) {
            zip(source, dest);
        } else if (source.toLowerCase().endsWith("rar")) {
            rar(source, dest);
        }
        log.debug("----解压完成，到 ：" + dest);
    }

    /**
     * 解压Zip
     *
     * @param source
     * @param dest
     */
    private void zip(String source, String dest) {
        String password = "password";
        try {
            File zipFile = new File(source);
            ZipFile zFile = new ZipFile(zipFile); // 首先创建ZipFile指向磁盘上的.zip文件
            if (this.coding != null) {
                zFile.setFileNameCharset(this.coding);
            }
            File destDir = new File(dest); // 解压目录   
//            if (zFile.isEncrypted()) {
//                zFile.setPassword(password.toCharArray()); // 设置密码   
//            }
            zFile.extractAll(dest);// 将文件抽出到解压目录(解压)   
            List<FileHeader> headerList = zFile.getFileHeaders();
            List<File> extractedFileList = new ArrayList<File>();
            for (FileHeader fileHeader : headerList) {
                if (!fileHeader.isDirectory()) {
                    extractedFileList.add(new File(destDir, fileHeader.getFileName()));
                }
            }
            File[] extractedFiles = new File[extractedFileList.size()];
            extractedFileList.toArray(extractedFiles);
//            for (File f : extractedFileList) {
//                System.out.println(f.getAbsolutePath() + "....");
//            }
        } catch (ZipException e) {
            log.debug("----解压文件失败");
        }
    }

    /**
     * 解压rar
     *
     * @param source 压缩包路径
     * @param dest   解压目录
     * @throws Exception
     */

    private void rar(String source, String dest) {
        if (!source.toLowerCase().endsWith(".rar")) {
            System.out.println("非rar文件！");
            return;
        }
        File dstDiretory = new File(dest);
        if (!dstDiretory.exists()) {// 目标目录不存在时，创建该文件夹
            dstDiretory.mkdirs();
        }
        File fol, out;
        Archive a;
        a = null;
        try {
            a = new Archive(new FileInputStream(new File(source)));
            if (a.isEncrypted()) {
                System.out.println("源压缩文件被加密!");
                return;
            }
            a.getMainHeader().print(); // 打印文件信息.
            //FileHeader fh = a.nextFileHeader();
            com.github.junrar.rarfile.FileHeader fh = a.nextFileHeader();
            while (fh != null) {
                if (fh.isDirectory()) { // 文件夹
                    // 如果是中文路径，调用getFileNameW()方法，否则调用getFileNameString()方法，还可以使用if(fh.isUnicode())
                    if (existZH(fh.getFileNameW())) {
                        fol = new File(dest + File.separator
                                + fh.getFileNameW());
                    } else {
                        fol = new File(dest + File.separator + fh.getFileNameString());

                    }
                    fol.mkdirs();
                } else { // 文件
                    if (existZH(fh.getFileNameW())) {
                        out = new File(dest + File.separator + fh.getFileNameW().trim());
                    } else {
                        out = new File(dest + File.separator + fh.getFileNameString().trim());
                    }
                    //System.out.println(out.getAbsolutePath());
                    try {// 之所以这么写try，是因为万一这里面有了异常，不影响继续解压.
                        if (!out.exists()) {
                            if (!out.getParentFile().exists()) {// 相对路径可能多级，可能需要创建父目录.
                                out.getParentFile().mkdirs();
                            }
                            out.createNewFile();
                        }
                        FileOutputStream os = new FileOutputStream(out);
                        a.extractFile(fh, os);
                        os.close();
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                fh = a.nextFileHeader();
            }
            a.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 判断是否是中文
     *
     * @param str
     * @return
     */
    public boolean existZH(String str) {
        String regEx = "[\\u4e00-\\u9fa5]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        while (m.find()) {
            return true;
        }
        return false;
    }
}
