package com.af.plugins.string;

/**
 * 函数式String处理类
 */
public class StringEx {


    private String innerStrnig;


    public StringEx(String dispose){
        this.innerStrnig = dispose;
    }

    /**
     * 根据传入的字符串截取掉之前的内容，若无，则返回本身
     * @param sign 截取参数
     * @return 本身
     */
    public StringEx removeBefore(String sign){
        if(sign == null){
            return this;
        }
        int index= this.innerStrnig.indexOf(sign);
        if(index == -1){
            return this;
        }
        this.innerStrnig =this.innerStrnig.substring(index);
        return this;
    }
    /**
     * 截取前的char重载
     * @param sign
     * @return
     */
    public StringEx removeBefore(char sign){
        return this.removeBefore(sign+"");
    }
    /**
     * 截取前的int重载
     * @param sign
     * @return
     */
    public StringEx removeBefore(int sign){
        return this.removeBefore(sign+"");
    }



    /**
     * 根据传入的字符串截取掉之后的内容，若无，则返回本身
     * @param sign 截取参数
     * @return 本身
     */
    public StringEx removeAfter(String sign){
        if(sign == null){
            return this;
        }
        int index= this.innerStrnig.lastIndexOf(sign);
        if(index == -1){
            return this;
        }
        this.innerStrnig =this.innerStrnig.substring(0,index+1);
        return this;
    }
    /**
     * 截取后的重载
     * @param sign
     * @return
     */
    public StringEx removeAfter(char sign){
        return this.removeAfter(sign+"");
    }
    /**
     * 截取后的重载
     * @param sign
     * @return
     */
    public StringEx removeAfter(int sign){
        return this.removeAfter(sign+"");
    }


    public String toString(){
        return this.innerStrnig;
    }
}
