package com.af.plugins;

import com.aote.logic.LogicMapper;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.InputStream;
import java.util.*;

public class GetModuleXml {

    private static List<String> list ;


    public static String[] getModuleXmlName(){
        if (list == null){
            loadList();
        }
        return  list.toArray(new String[0]);
    }

    /**
     * 获取所有模块映射文件
     * @return
     */

    @SuppressWarnings("rawtypes")
    private static void loadList() {
        list = new ArrayList<>();

        InputStream module = LogicMapper.class.getClassLoader()
                .getResourceAsStream("module.xml");
        try {
            if (module == null) {
                throw new RuntimeException("模块定义文件module.xml未找到");
            }
            parseModule(module);
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }

    }

    private static void parseModule(InputStream input) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(input);
        Element root = document.getRootElement();
        for (Iterator it = root.elementIterator("module"); it.hasNext();) {
            Element elm = (Element) it.next();
            String name = elm.attribute("name").getValue();
            list.add(name);
        }
    }
}
