/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.timeoutReturn;

import com.aote.config.SystemConfig;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Component
public class RedisCacheTools {
    private static Logger log = Logger.getLogger(RedisCacheTools.class);
    private static JedisPool jedisPool;
    private static final JedisPoolConfig config;

    public void getJedisPool(String host, int port) {
        jedisPool = new JedisPool((GenericObjectPoolConfig)config, host, port);
    }

    public Jedis getJedis() {
        return jedisPool.getResource();
    }

    public String getValue(String key) {
        try (Jedis jedis = this.getJedis();){
            String string = jedis.get(key);
            return string;
        }
    }

    public String setValue(String key, String value, int timeout) {
        if (timeout <= 0) {
            timeout = 1800;
        }
        try (Jedis jedis = this.getJedis();){
            String string = jedis.setex(key, timeout, value);
            return string;
        }
    }

    public String setValue(String key, String value) {
        try (Jedis jedis = this.getJedis();){
            String string = jedis.setex(key, 1800, value);
            return string;
        }
    }

    public String removeKey(String key) {
        try (Jedis jedis = this.getJedis();){
            Long valString = jedis.del(key);
            String string = valString.toString();
            return string;
        }
    }

    static {
        config = new JedisPoolConfig();
        config.setMaxTotal(200);
        config.setMaxIdle(200);
        config.setMaxWaitMillis(10000L);
        config.setTestOnBorrow(false);
        try {
            if (SystemConfig.Redis.hasRegisterUrl()) {
                String[] url = SystemConfig.Redis.getHostName().split(":");
                jedisPool = new JedisPool((GenericObjectPoolConfig)config, url[0], Integer.parseInt(url[1]));
            }
        }
        catch (Exception e) {
            log.debug((Object)"\u83b7\u53d6config.json redis\u914d\u7f6e\u5931\u8d25\uff01\uff01");
        }
    }
}

