/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import cn.hutool.core.net.URLEncoder;
import com.af.plugins.HttpConnectionPoolUtil;
import com.af.plugins.HttpDeleteWithBody;
import com.aote.ThreadResource;
import com.aote.config.SystemConfig;
import com.aote.logic.SpringBeansPour;
import com.aote.transaction.ClientSession;
import com.aote.transaction.SessionPool;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;

public class RestTools
implements SpringBeansPour {
    private ClientSession clientSession;

    public void initBeans(ApplicationContext applicationContext) {
        this.clientSession = (ClientSession)applicationContext.getBean(ClientSession.class);
    }

    public static String request(String path, String value, String headers, HttpRequestBase base) {
        if (!path.startsWith("http")) {
            path = SystemConfig.System.getProxyUrl();
        }
        try {
            JSONObject headerJson = headers == null || "".equals(headers) ? new JSONObject() : new JSONObject(headers);
            if (!headerJson.has("Content-Type")) {
                headerJson.put("Content-Type", (Object)"application/json");
            }
            return HttpConnectionPoolUtil.request(path, value, headerJson.toString(), base);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HttpEntity requestPostFile(String path, String value, String headers, HttpEntityEnclosingRequestBase base) {
        if (!path.startsWith("http")) {
            path = SystemConfig.System.getProxyUrl();
        }
        try {
            JSONObject headerJson = headers == null || "".equals(headers) ? new JSONObject() : new JSONObject(headers);
            if (!headerJson.has("Content-Type")) {
                headerJson.put("Content-Type", (Object)"application/json");
            }
            return HttpConnectionPoolUtil.requestMetaData(path, value, headerJson.toString(), (HttpRequestBase)base);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String post(String path, String value, String headers) {
        return RestTools.request(path, value, headers, (HttpRequestBase)new HttpPost());
    }

    public static String post(String path, JSONObject value, JSONObject headers) {
        if (value == null) {
            return RestTools.post(path, null, headers.toString());
        }
        return RestTools.post(path, value.toString(), headers.toString());
    }

    public static String post(String path, JSONObject value) {
        return RestTools.post(path, value.toString(), null);
    }

    public static String post(String path, String value) {
        return RestTools.post(path, value, null);
    }

    public static String post(String path) {
        return RestTools.post(path, "", null);
    }

    public static String postheader(String path, String value) {
        JSONObject headers = new JSONObject();
        headers.put("Content-Type", (Object)"application/json");
        return RestTools.request(path, value, headers.toString(), (HttpRequestBase)new HttpPost());
    }

    public static HttpEntity postHttpEntity(String path, JSONObject value) {
        JSONObject headers = new JSONObject();
        headers.put("Content-Type", (Object)"application/json");
        return RestTools.requestPostFile(path, value.toString(), headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPost());
    }

    public static String get(String path, String headers) {
        return RestTools.request(path, null, headers, (HttpRequestBase)new HttpGet());
    }

    public static String get(String path, JSONObject headers) {
        return RestTools.get(path, headers.toString());
    }

    public static String get(String path) {
        return RestTools.get(path, "");
    }

    public static JSONObject getJson(String path) {
        return RestTools.getJson(path, null);
    }

    public static JSONObject getJson(String path, JSONObject headers) {
        JSONObject resultObj;
        String requestResult = RestTools.get(path, headers.toString());
        if (requestResult.startsWith("{")) {
            resultObj = new JSONObject(requestResult);
        } else if (requestResult.startsWith("[")) {
            resultObj = new JSONArray(requestResult);
        } else {
            throw new RuntimeException("\u8c03\u7528rest\u670d\u52a1\u5931\u8d25\u3002");
        }
        JSONObject result = new JSONObject();
        result.put("code", 200);
        result.put("data", (Object)resultObj);
        return result;
    }

    public static String put(String path, String value, String headers) {
        return RestTools.request(path, value, headers, (HttpRequestBase)new HttpPut());
    }

    public static String put(String path, JSONObject value, JSONObject headers) {
        if (value == null) {
            return RestTools.put(path, null, headers.toString());
        }
        return RestTools.put(path, value.toString(), headers.toString());
    }

    public static String put(String path, String value) {
        return RestTools.put(path, value, "");
    }

    public static String put(String path, JSONObject value) {
        return RestTools.put(path, value.toString(), "");
    }

    public static String put(String path) {
        return RestTools.put(path, "", null);
    }

    public static String delete(String path, String value, String headers) {
        return RestTools.request(path, value, headers, (HttpRequestBase)new HttpDeleteWithBody());
    }

    public static String delete(String path, JSONObject value, JSONObject headers) {
        if (value == null) {
            return RestTools.delete(path, null, headers.toString());
        }
        return RestTools.delete(path, value.toString(), headers.toString());
    }

    public static String delete(String path, String value) {
        return RestTools.delete(path, value, "");
    }

    public static String delete(String path, JSONObject value) {
        return RestTools.delete(path, value.toString(), "");
    }

    public static String delete(String path) {
        return RestTools.delete(path, "", null);
    }

    public Object action(JSONObject param) {
        String actual;
        String url = param.getString("url");
        String data = param.getString("data");
        Integer id = (Integer)ThreadResource.SessionId.get();
        if (id != null) {
            int toId = SessionPool.getInstance().createCallSession(id.intValue(), url);
            JSONObject headers = new JSONObject();
            headers.put("session", (Object)(toId + ""));
            actual = RestTools.post(url, new JSONObject(data), headers);
        } else if (null != this.clientSession && this.clientSession.sessionId != null && this.clientSession.sessionId != "") {
            JSONObject headers = new JSONObject();
            headers.put("session", (Object)this.clientSession.sessionId);
            actual = RestTools.post(url, new JSONObject(data), headers);
        } else {
            actual = RestTools.post(url, data);
        }
        JSONObject result = new JSONObject();
        result.put("code", 200);
        if (actual.startsWith("{")) {
            JSONObject actualJson = new JSONObject(actual);
            if (actualJson.has("status")) {
                result.put("code", actualJson.get("status"));
                result.put("data", (Object)actualJson.getString("data"));
            } else {
                result.put("data", (Object)actualJson);
            }
        } else if (actual.startsWith("[")) {
            result.put("data", (Object)new JSONArray(actual));
        } else {
            result.put("data", (Object)actual);
        }
        return result;
    }

    public static String formatURL(String url, JSONObject params) {
        int capacity = params.length() * 30;
        StringBuilder buffer = new StringBuilder(capacity);
        buffer.append(url).append("?");
        Iterator keys = params.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String val = String.valueOf(params.get(key));
            if (!"".equals(val)) {
                buffer.append(key).append("=").append(val);
            } else {
                buffer.append(key);
            }
            if (!keys.hasNext()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    public static String formatAndEncodeURL(String url, JSONObject params) {
        String urlStr = RestTools.formatURL(url, params);
        return urlStr.substring(0, urlStr.indexOf("?") + 1) + URLEncoder.QUERY.encode(urlStr.substring(urlStr.indexOf("?") + 1), StandardCharsets.UTF_8);
    }

    public static String getStandardURL(String protocolType, String url, String port, String paramStr) {
        if (port == null) {
            port = "80";
        }
        url = protocolType + "://" + url + ":" + port;
        if (paramStr != null) {
            url = url + paramStr;
        }
        return url;
    }
}

