package com.af.plugins.office;

import com.alibaba.excel.EasyExcel;
import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EasyExport {
    /**
     * 传入导出数据，导出字段，和一些特殊表头
     * @param jsonObject
     * @return
     */
    public String exportFile(JSONObject jsonObject){
        JSONObject handInfo = jsonObject.getJSONObject("hand");
        JSONArray bodyInfo = jsonObject.getJSONArray("body");
        JSONArray footerInfo = handInfo.getJSONArray("footer");
        bodyInfo = this.getJudgeArray(bodyInfo);
        JSONArray keyNameVS = jsonObject.getJSONObject("hand").getJSONArray("keyNameVS");
        List<List<String>> hand = this.getHand(handInfo);
        List<List<Object>> body = this.getBody(bodyInfo,handInfo,keyNameVS);
        body = this.getFooter(footerInfo, (ArrayList) body);
        String downpath =getpath() + jsonObject.get("filename")+".xlsx";
        EasyExcel.write(downpath).head(hand).sheet("模板").registerWriteHandler(
                new ExcelWriteHandle(handInfo.getJSONArray("inLine").length(),handInfo.getJSONArray("otherLine").length())).doWrite(body);
        return downpath;
    }

    /**
     * 获取导出路径
     * @return
     */
    private String getpath(){
        String path = EasyExport.class.getClassLoader().getResource("config.json")
                .getPath();
        String rootPath = path.split("WEB-INF")[0]+"/excel/";
        return rootPath;
    }

    /**
     * 生成导出表头内容
     * @param handInfo
     * @return
     */
    private List<List<String>> getHand(JSONObject handInfo){
        List<List<String>> handList = new ArrayList<List<String>>();
        JSONArray keyNameVS = handInfo.getJSONArray("keyNameVS");
        boolean isInLine = false;

        if (handInfo.has("inLine")){
            isInLine = true;
        }

        for (int i = 0; i < keyNameVS.length() ; i++) {
            List<String> onCloum = new ArrayList<String>();
            if (isInLine){
                handInfo.getJSONArray("inLine").forEach(( v )->{
                    onCloum.add(v.toString());
                });
            }
            handList.add(onCloum);
        }
        return handList;
    }

    /**
     * 生成导出表body内容
     * @param bodyInfo
     * @param handInfo
     * @param keyNameVS
     * @return
     */
    private List<List<Object>> getBody(JSONArray bodyInfo,JSONObject handInfo,JSONArray keyNameVS){
        List<List<Object>> list = new ArrayList<List<Object>>();
        JSONArray keyName = new JSONArray();
        boolean isotherLine = false;
        if(handInfo.has("otherLine")){
            isotherLine = true;
        }
        if(isotherLine ){
            for(int i=0;i<handInfo.getJSONArray("otherLine").length();i++){
                List<Object> data = new ArrayList<Object>();
                JSONArray otherLine = handInfo.getJSONArray("otherLine");
                JSONArray otherFild= (JSONArray) otherLine.get(i);
                for(int j=0;j<otherFild.length();j++){
                    data.add(otherFild.get(j).toString());
                }
                list.add(data);
            }

        }
        List<Object> onCloum = new ArrayList<Object>();
        for (int i = 0; i < keyNameVS.length(); i++) {
            onCloum.add(keyNameVS.getString(i).split(":")[1]);
        }
        list.add(onCloum);
        keyNameVS.forEach(( v )->{
            String[] kV = v.toString().split(":");
            keyName.put(kV[0]);
        });
        for (int i = 0; i < bodyInfo.length(); i++) {
            List<Object> data = new ArrayList<Object>();
            JSONObject oneLine = bodyInfo.getJSONObject(i);
            for (int j = 0; j < keyName.length(); j++) {
                data.add(oneLine.get(keyName.get(j).toString()));
            }
            list.add(data);
        }
        return list;
    }

    /**
     * 生成excel的footer内容
     * @param footerInfo
     * @param list
     * @return
     */
    public List<List<Object>> getFooter(JSONArray footerInfo,ArrayList list){
        if(footerInfo == null) return list;
        if(footerInfo.length() == 0) return list;
        for(int i=0;i<footerInfo.length();i++){
            List<Object> data = new ArrayList<Object>();
            JSONArray otherFild= (JSONArray) footerInfo.get(i);
            for(int j=0;j<otherFild.length();j++){
                data.add(otherFild.get(j).toString());
            }
            list.add(data);
        }
        return list;
    }

    /**
     * 处理插件处理不了的数据，进行转换
     * @param json
     * @return
     */
    public JSONArray getJudgeArray(JSONArray json){
        if(json == null) return  null;
        JSONArray newarray = new JSONArray();
        for(int i=0; i<json.length();i++){
            JSONObject map = (JSONObject) json.get(i);
            JSONObject newobject = new JSONObject();
            Iterator<String> it = map.keys();
            while(it.hasNext()){
                String next = it.next();
                Object o = map.get(next);
                if(map.get(next) instanceof BigInteger){
                    newobject.put(next,Integer.valueOf(map.get(next).toString()));
                }else if(map.isNull(next)){
                    newobject.put(next,"");
                }else if(map.get(next) instanceof BigDecimal){
                    newobject.put(next,map.get(next).toString());
                }else if(map.get(next) instanceof Timestamp){
                    newobject.put(next,new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(map.get(next)));
                }else{
                    newobject.put(next,map.get(next));
                }
            }
            newarray.put(newobject);
        }
        return newarray;
    }
}
