package com.af.plugins;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

/**
 * 图像信息类
 */
public class ImageData {
    /**
     * 文件名
     */
    private String name;
    /**
     * 宽度
     */
    private int width;
    /**
     * 高度
     */
    private int height;
    /**
     * base64码
     */
    private String base64Str;
    /**
     * 图片类型
     */
    private String imageType;

    /**
     * 获取图片信息
     * @param path 文件路径
     * @return 图片信息
     */
    public static ImageData getImageData(String path) throws IOException {
        File picture = new File(path);
        //文件名
        String fileName = picture.getName();
        //文件类型
        String prefix = fileName.substring(fileName.lastIndexOf(".") + 1);
        BufferedImage sourceImg = ImageIO.read(new FileInputStream(picture));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write(sourceImg, prefix, out);
        byte[] source = out.toByteArray();
        ImageData result = new ImageData();
        //文件名
        result.name = fileName;
        //图片类型
        result.imageType = prefix;
        //宽度
        result.width = sourceImg.getWidth();
        //高度
        result.height = sourceImg.getHeight();
        //base64串
        result.base64Str = ConvertTools.base64Encode(source);
        return result;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getBase64Str() {
        return base64Str;
    }

    public void setBase64Str(String base64Str) {
        this.base64Str = base64Str;
    }

    public String getImageType() {
        return imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
