package com.aote.plugins.impexp.exportfile;

import com.aote.path.PathServer;
import com.aote.sql.SqlServer;
import com.aote.util.ExcelUtil;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import javax.sql.DataSource;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.*;

@Component
@Transactional
public class ExportFilePlus  implements IExportFile {
    // json形式的配置内容
    private JSONObject map = null;
    // 导出进度
    private double exportspeed = 0;

    // 一个sheet最大行数
    private static final int MAX_ROWS_PER_SHEET = 1001;
    // 一次查询最大数量,更新此数值可以影响查询次数
    private static final int MAX_SELECT_LEN = 101;
    private static final String defaultCondition = "{orderitem: 'id',condition: '1=1'}";
    static Logger log = Logger.getLogger(ExportFilePlus.class);
    @Autowired
    private DataSource dataSource;
    @Autowired
    private PathServer pathServer;
    @Autowired
    private SqlServer sqlServer;
    /**
     * 导出数据（无模板）
     * @param condition 导出时的前台传递的数据
     * @param configName 导出对应的配置内容
     * @return
     * @throws Exception
     */
    @Override
    public JSONArray export(String condition, String configName) throws Exception {
        if(condition==null || "".equals(condition)){
            return new JSONArray();
        }
        return noTemplate(condition);
    }

    @Override
    public JSONArray export(String condition, String configName, Session session) throws Exception {
        return null;
    }

    /**
     * 无模板导出
     * @param condition: 前台传入的条件等内容，格式为：{templateName: 要保存的excel文件名}
     * @return
     * @throws Exception
     */
    private JSONArray noTemplate(String condition) throws Exception {
        JSONArray result = new JSONArray();
        JSONObject json = new JSONObject();
        long tick = System.currentTimeMillis();
        JSONObject jsonObject = new JSONObject(condition);
        // 从前台传入的内容中，获取excel文件名，templateName为excel文件名
        String filepath = getFilePath(new JSONObject(condition).getString("templateName")+".xlsx");
        json.put("filename", filepath);
        result.put(json);
        //
        if(new JSONObject(condition).has("sqlName")){
            export(new JSONObject(condition).getString("sqlName"), condition, null, filepath);
        }else if(new JSONObject(condition).has("pathName")){
            exportpath(new JSONObject(condition).getString("pathName"), condition, null, filepath);
        }

        tick = System.currentTimeMillis() - tick;
        System.out.println("进行Excel导出耗时：" + (tick / 1000.0) + "秒");
        System.out.println("文件名：" + result);
        return result;
    }

    /**
     * 取得导出文件名称
     * @param name
     * @return
     */
    private String getFilePath(String name) {
        String excelFileName = (name == null ? UUID.randomUUID() + ".xlsx" : name);
        String path = ExcelUtil.class.getClassLoader().getResource("config.json")
                .getPath();
        String rootPath = path.split("WEB-INF")[0];
        //rootPath = "D://1/";
        String filePath = rootPath + "excel/" + excelFileName;
        return filePath;
    }

    /**
     * Real export stuff
     *
     * @param name
     * @param templateName
     * @throws Exception
     */
    private void export(String name, String body, String templateName,
                        String filePath) throws Exception {
        if(templateName!=null){
            log.warn("暂时不支持模板导出");
            return;
        }
        //初始化数据
        this.exportspeed = 0f;
        BigDecimal bg = null;
        JSONArray rs = null;
        ExcelUtil eu = null;
        String[][] footer = null;
        //导出前新建一个输出流（缓冲存储器）
        eu = new ExcelUtil();
        eu.createBook(null, filePath);
        JSONObject joParam = new JSONObject(body);
        if (joParam.has("total")) {
            footer = getFooter( joParam.getJSONArray("total"));
        }
        //获取本次导出的数量
        JSONObject exportlen = sqlServer.queryTotal(name,body);
        int datalen = (int) exportlen.get("n");
        int alllen = datalen;
        System.out.println("本次导出数量"+datalen);
        //是否进行多个sheet
        JSONArray exportdata = new JSONArray();
        if(datalen>(MAX_ROWS_PER_SHEET-1) && datalen%(MAX_ROWS_PER_SHEET-1)>0 ){
            //在多个sheet里多次查询处理的(此处只处理有两个及其以上的sheet的数据)
            for(int i=0;i<datalen/(MAX_ROWS_PER_SHEET-1);i++){
                for(int j=0;j<(MAX_ROWS_PER_SHEET-1)/(MAX_SELECT_LEN-1);j++){
                    int sqlpage = 0;
                    if(i == 0){
                        sqlpage = j+1;
                    }else{
                        sqlpage =(((MAX_ROWS_PER_SHEET-1)/(MAX_SELECT_LEN-1))*i) + (j+1)*i;
                    }
                    rs = sqlServer.query(name,sqlpage,(MAX_SELECT_LEN-1),body);
                    exportdata = concatJsonArray(exportdata, rs);
                    bg = new BigDecimal(rs.length()/(alllen*1.0)+exportspeed);
                    exportspeed =  bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
                }
                exportWithHedear(eu, joParam, exportdata, footer,false);
                exportdata = new JSONArray();
            }
            //处理最后一个sheet的
            int olresetlen = (datalen/(MAX_ROWS_PER_SHEET-1))*((MAX_ROWS_PER_SHEET-1)/(MAX_SELECT_LEN-1));
            datalen = datalen-((datalen/(MAX_ROWS_PER_SHEET-1))*(MAX_ROWS_PER_SHEET-1));
            exportdata = new JSONArray();
            //对于方到一个sheet里
            if(datalen>(MAX_SELECT_LEN-1)){
                int resetlen = 0;
                if(datalen>(MAX_SELECT_LEN-1)*(datalen/(MAX_SELECT_LEN-1))){
                    resetlen =datalen/(MAX_SELECT_LEN-1)+1;
                }else{
                    resetlen = datalen/(MAX_SELECT_LEN-1);
                }
                for(int i=0;i<resetlen;i++){
                    rs = sqlServer.query(name,olresetlen+i+1,(MAX_SELECT_LEN-1),body);
                    exportdata = concatJsonArray(exportdata, rs);
                    bg = new BigDecimal(rs.length()/(alllen*1.0)+ exportspeed);
                    exportspeed =  bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
                    if(i == resetlen-1){
                        exportWithHedear(eu, joParam, exportdata, footer,true);
                    }
                }
            }else{
                rs = sqlServer.query(name,olresetlen+1,(MAX_SELECT_LEN-1),body);
                bg = new BigDecimal(rs.length()/(alllen*1.0)+exportspeed);
                exportspeed = bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
                exportWithHedear(eu, joParam, rs, footer,true);
            }
        }else{
            //对于方到一个sheet里
            if(datalen>(MAX_SELECT_LEN-1)){
                int resetlen = 0;
                if(datalen>(MAX_SELECT_LEN-1)*(datalen/(MAX_SELECT_LEN-1))){
                    resetlen =datalen/(MAX_SELECT_LEN-1)+1;
                }else{
                    resetlen = datalen/(MAX_SELECT_LEN-1);
                }
                for(int i=0;i<resetlen;i++){
                    rs = sqlServer.query(name,i+1,(MAX_SELECT_LEN-1),body);
                    bg = new BigDecimal(rs.length()/(alllen*1.0)+exportspeed);
                    exportspeed =  bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
                    exportdata = concatJsonArray(exportdata, rs);
                    if(i == resetlen-1){
                        exportWithHedear(eu, joParam, exportdata, footer,true);
                    }
                }
            }else{
                rs = sqlServer.query(name,body,-1);
                bg = new BigDecimal(rs.length()/(alllen*1.0)+exportspeed);
                exportspeed =  bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
                exportWithHedear(eu, joParam, rs, footer,true);
            }
        }
    }

    /**
     * 获取导出进度
     * @return 导出进度
     */
    public double getExportspeed(){
        return exportspeed;
    }

    /**
     *  组合json到一个jsonarray
     * @param src 原json
     * @param des 合并的json
     * @return 合并后的json
     */
    public JSONArray concatJsonArray(JSONArray src ,JSONArray des){
        JSONArray result = new JSONArray();
        for(Object item : src){
            result.put(item);
        }
        for(Object item : des){
            result.put(item);
        }
        return result;
    }

    /**
     * Real export stuff
     *
     * @param name
     * @param templateName
     * @throws Exception
     */
    private void exportpath(String name, String body, String templateName,
                            String filePath) throws Exception {

        JSONObject joParam = new JSONObject(body);

        String[][] footer = null;
        if (joParam.has("total")) {
            JSONArray totals = joParam.getJSONArray("total");
            footer = getFooter(totals);
        }

        // 获取原始sql语句
        JSONObject joVariable = joParam.getJSONObject("data");
        //获取到结果集
        JSONArray result = pathServer.query(name, joParam.toString());
        try {
            exportWithHedearpath(filePath, joParam, result, footer);
        } catch (Exception e){
            log.error("导出文件: " + name + "出错，原因 ：" + e.getMessage());
        }
    }

    /**
     * get footer lines
     *
     * @param totals
     * @return
     */
    private String[][] getFooter(JSONArray totals) {
        int n = totals.length();
        String[][] footer = new String[n][];
        for (int i = 0; i < n; i++) {
            JSONObject jo = totals.getJSONObject(i);
            String[] names = JSONObject.getNames(jo);
            Arrays.sort(names, new Comparator<String>() {
                @Override
                public int compare(String o1, String o2) {
                    return Integer.parseInt(o1) - Integer.parseInt(o2);
                }
            });
            footer[i] = new String[names.length];
            for (int j = 0; j < names.length; j++) {
                if (jo.isNull(names[j])) {
                    footer[i][j] = null;
                } else {
                    footer[i][j] = jo.get(names[j]) + "";
                }
            }
        }
        return footer;
    }
    /**
     * export with header info
     *
     * @param filePath
     * @param joParam
     * @param sql
     * @param rs
     * @param footer
     * @throws Exception
     * @throws SQLException
     */
    private void exportWithHedear(String filePath, JSONObject joParam,
                                  String sql, ResultSet rs, String[][] footer) throws Exception,
            SQLException {
        boolean fromHbm = false;
        boolean isSum = false;

        // 新的添加表头
        String[][] newHeader = null;
        if (joParam.has("header")) {
            JSONArray headerArray = joParam.getJSONArray("header");
            int n = headerArray.length();
            // 创建多维数组
            newHeader = new String[n][];
            // 往数组添加数据
            jsonToTwoArr(newHeader, headerArray, n);
        }

        // 新的添加表尾
        if (joParam.has("footer")) {
            JSONArray footerArray = joParam.getJSONArray("footer");
            int n = footerArray.length();
            // 创建多维数组
            String[][] footerth = new String[n][];
            // 往数组添加数据
            jsonToTwoArr(footerth, footerArray, n);
            // 进行替换
            footer = footerth;
        }

        // find out the headers
        JSONArray joField = joParam.getJSONArray("field");
        JSONArray sumName;
        if(joParam.has("sumName")){
            Object object = joParam.get("sumName");
            if(object instanceof JSONArray){
                sumName = (JSONArray) object;
                isSum = true;
            }
        }

        List<Object> sumNames = null;
        Object[] sum = null;
        List<Object> sums;

        if(isSum){
            sumName = joParam.getJSONArray("sumName");
            sumNames = sumName.toList();
        }

        Map<String, String> colsMap = new LinkedHashMap<String, String>();
        findOutHeaders(joField, colsMap);
        String[] header = colsMap.values().toArray(new String[colsMap.size()]);
        String[] cols = colsMap.keySet().toArray(new String[colsMap.size()]);

        // creating excel starts
        ExcelUtil eu = new ExcelUtil();
        eu.createBook(null, filePath);

        int n = 1;
        List<List<Object>> rows = new ArrayList<List<Object>>();
        if(isSum){
            sum = new BigDecimal[colsMap.size()];
        }
        while (rs.next()) {
            if (n % MAX_ROWS_PER_SHEET == 0) {
                eu.createSheet();
                n = 1;
                eu.writeToSheet(rows, header, footer, newHeader);
                rows = new ArrayList<List<Object>>();
            }
            List<Object> fieldList = new ArrayList<Object>();
            if (fromHbm) {
                fieldList.add(rs.getObject("id"));
            }
            for (int i = (fromHbm ? 1 : 0); i < colsMap.size(); i++) {
                Object object = rs.getObject(cols[i]);
                if(sumNames != null && sum != null){
                    if (sumNames.contains(cols[i]))
                    {
                        if(sum[i]==null){
                            BigDecimal num2 = new BigDecimal(String.valueOf(object));
                            sum[i] = num2;
                        } else {
                            BigDecimal num1 = new BigDecimal(String.valueOf(sum[i]));
                            BigDecimal num2 = new BigDecimal(String.valueOf(object));
                            sum[i] = num1.add(num2);
                        }
                    } else sum[i]= null;
                }

                fieldList.add(object);
            }
            rows.add(fieldList);
            n++;
        }
        if(sum != null){
            sums = Arrays.asList(sum);
            rows.add(sums);
        }
        // not enough to reach the max row limit
        if (n > 1) {
            eu.createSheet();
            eu.writeToSheet(rows, header, footer, newHeader);
        }
        eu.saveBook();
    }
    private void jsonToTwoArr(String[][] newHeader, JSONArray headerArray, int n) {
        for (int i = 0; i < n; i++) {
            JSONArray array = headerArray.getJSONArray(i);
            int p = array.length();
            newHeader[i] = new String[p];
            for (int j = 0; j < p; j++) {
                newHeader[i][j] = String.valueOf(array.get(j));
            }
        }
    }

    /**
     * 可以进行多次组织数据将所有数据放到输出流中，进行统一输出
     * @param eu excel导出工具（输出流）
     * @param joParam
     * @param array
     * @param footer
     * @param isexport 是否进行导出
     * @throws Exception
     * @throws SQLException
     */
    private void exportWithHedear(ExcelUtil eu, JSONObject joParam,
                                 JSONArray array, String[][] footer,boolean isexport) throws Exception,
            SQLException {
        boolean fromHbm = false;
        boolean isSum = false;

        // find out the headers
        JSONArray joField = joParam.getJSONArray("field");
        JSONArray sumName;
        if(joParam.has("sumName")){
            Object object = joParam.get("sumName");
            if(object instanceof JSONArray){
                sumName = (JSONArray) object;
                isSum = true;
            }
        }

        List<Object> sumNames = null;
        Object[] sum = null;
        List<Object> sums;

        if(isSum){
            sumName = joParam.getJSONArray("sumName");
            sumNames = sumName.toList();
        }

        Map<String, String> colsMap = new LinkedHashMap<String, String>();
        findOutHeaders(joField, colsMap);
        String[] header = colsMap.values().toArray(new String[colsMap.size()]);
        String[] cols = colsMap.keySet().toArray(new String[colsMap.size()]);



        int n = 1;
        List<List<Object>> rows = new ArrayList<List<Object>>();
        if(isSum){
            sum = new BigDecimal[colsMap.size()];
        }
        for(Object item : array) {
            JSONObject objectItem = (JSONObject) item;
            if (n % MAX_ROWS_PER_SHEET == 0) {
                eu.createSheet();
                n = 1;
                eu.writeToSheet(rows, header, footer);
                rows = new ArrayList<List<Object>>();
            }
            List<Object> fieldList = new ArrayList<Object>();
            if (fromHbm) {
                fieldList.add(objectItem.get("id"));
            }
            for (int i = (fromHbm ? 1 : 0); i < colsMap.size(); i++) {
                Object object = objectItem.get(cols[i]);
                if(sumNames != null && sum != null){
                    if (sumNames.contains(cols[i]))
                    {
                        if(sum[i]==null){
                            BigDecimal num2 = new BigDecimal(String.valueOf(object));
                            sum[i] = num2;
                        } else {
                            BigDecimal num1 = new BigDecimal(String.valueOf(sum[i]));
                            BigDecimal num2 = new BigDecimal(String.valueOf(object));
                            sum[i] = num1.add(num2);
                        }
                    } else sum[i]= null;
                }

                fieldList.add(object);
            }
            rows.add(fieldList);
            n++;
        }
        if(sum != null){
            sums = Arrays.asList(sum);
            rows.add(sums);
        }
        // not enough to reach the max row limit
        if (n > 1) {
            eu.createSheet();
            eu.writeToSheet(rows, header, footer);
        }
        if(isexport){
            eu.saveBook();
        }
    }

    /**
     * find out headers
     *
     * @param joField
     * @param headers
     */
    private void findOutHeaders(JSONArray joField, Map<String, String> headers) {
        for (Object temp : joField) {
            String col = ((String) temp).split(":")[0];
            headers.put(col, ((String) temp).split(":")[1]);
        }
    }
    /**
     * export with template
     *
     * @param templateName
     * @param filePath
     * @param footer
     * @throws Exception
     */
    private void exportWithTemplate(String templateName,String filePath, ResultSet rs, String[][] footer) throws Exception {
        // creating excel starts
        ExcelUtil eu = new ExcelUtil();
        eu.createBook(templateName, filePath);
        int nCol = rs.getMetaData().getColumnCount();
        int n = 1;
        List<List<Object>> rows = new ArrayList<List<Object>>();
        while (rs.next()) {
            if (n % MAX_ROWS_PER_SHEET == 0) {
                eu.createSheet();
                n = 1;
                eu.writeToSheet(rows, null, footer);
                rows = new ArrayList<List<Object>>();
            }
            List<Object> fieldList = new ArrayList<Object>();
            for (int i = 1; i <= nCol; i++) {
                Object object = rs.getObject(i);
                fieldList.add(object);
            }
            rows.add(fieldList);
            n++;
        }
        // not enough to reach the max row limit
        if (n > 1) {
            eu.createSheet();
            eu.writeToSheet(rows, null, footer);
        }
        eu.saveBook();
    }
    /**
     * export with header info
     *
     * @param filePath
     * @param joParam
     * @param footer
     * @throws Exception
     * @throws SQLException
     */
    private void exportWithHedearpath(String filePath, JSONObject joParam,
                                      JSONArray jsonarry, String[][] footer) throws Exception,
            SQLException {
        JSONArray joField = joParam.getJSONArray("field");
        Map<String, String> colsMap = new LinkedHashMap<String, String>();
        findOutHeaders(joField, colsMap);
        String[] header = colsMap.values().toArray(new String[colsMap.size()]);
        String[] cols = colsMap.keySet().toArray(new String[colsMap.size()]);
        // creating excel starts
        ExcelUtil eu = new ExcelUtil();
        eu.createBook(null, filePath);
        log.error("数据长度是: " + jsonarry.length());
        int n = 1;
        List<List<Object>> rows = new ArrayList<List<Object>>();
        while (n<=jsonarry.length()) {
            if (n % MAX_ROWS_PER_SHEET == 0) {
                eu.createSheet();
                n = 1;
                eu.writeToSheet(rows, header, footer);
                rows = new ArrayList<List<Object>>();
            }
            List<Object> fieldList = new ArrayList<Object>();
            for (int i = 0; i < colsMap.size(); i++) {
                Object object = this.getSObject(jsonarry.getJSONObject(n-1),cols[i]);
                fieldList.add(object);
            }
            rows.add(fieldList);
            n++;
        }
        // not enough to reach the max row limit
        if (n > 1) {
            eu.createSheet();
            eu.writeToSheet(rows, header, footer);
        }
        eu.saveBook();
    }
    /**
     *
     * @param obj
     * @param filestr
     * @return
     */
    private Object getSObject(JSONObject obj,String filestr) {
        Object result=null;
        try {
            //得到关系字符串
            String[] strArray = filestr.split("\\.");
            int i=0;
            result=obj;
            while (i<strArray.length){
                result=this.getSValue((JSONObject)result,strArray[i]);
                i++;
            }
        }catch (Exception e){
            log.error("解析对象出错: " + obj.toString() + "出错，"+filestr+"原因 ：" + e.getMessage());
        }
        if(result instanceof JSONObject){
            result="";
        }
        return result;
    }
    private Object getSValue(JSONObject obj,String res) {
        Object result=null;
        try {
            if(obj!=null){
                String copy=res;
                if(copy.indexOf("[")>-1&&copy.indexOf("]")>-1){
                    String intflag = copy.substring(res.indexOf("[") + 1, copy.lastIndexOf("]")) ;
                    if(intflag.length()>0){
                        String prop=res.substring(0,res.indexOf("["));
                        if(obj.has(prop)){
                            result =obj.getJSONArray(prop).get(Integer.parseInt(intflag));
                        }else {
                            result=null;
                        }
                    }
                }else {
                    result =obj.get(res);
                }
            }
        }catch (Exception e){
            log.error("解析对象出错: " + obj.toString() + "出错，"+res+"原因 ：" + e.getMessage());
        }
        return result;
    }

}
