package com.af.plugins.android;

//import android.util.Log;

import com.szzt.sdk.device.card.ContactlessCardReader;
import com.szzt.sdk.device.card.SmartCardReader;
import com.af.plugins.android.zt.BlueRW;
import com.af.plugins.android.zt.ReadCard;
import com.af.plugins.android.zt.SlotCard;
import com.af.plugins.android.zt.StringUtility;
import com.af.plugins.android.zt.WriCard;

/**
 * Created by LGY on 2018-05-14.
 */

public class ZTCAReader {
    public ContactlessCardReader rfReader;
    public SmartCardReader icReader;
    // 接触是卡槽号
    public int defaultReaderNo = 0;
    private BlueRW blueRW = new BlueRW();

    /**
     * 接触式和非接触式卡槽那个有卡
     * @return SlotCard对象
     */
    public SlotCard findTheSlotThatHasCardOn() {
        SlotCard sc = new SlotCard();
        int rfCardSlot;
        int icCardSlot;
        byte[] data=new byte[256];
        rfCardSlot = ifCardOnContactlessSlot(data);
        icCardSlot = ifCardInSlot(data);
        if(rfCardSlot == -2 && icCardSlot == -2) {
            sc.slot = SlotCard.WRONG_SLOT;
        }
        else if(rfCardSlot == -1 && icCardSlot == -1) {
            sc.slot = SlotCard.NO_SLOT;
        }
        else if(rfCardSlot >=0 && icCardSlot >= 0) {
            sc.slot = SlotCard.DOUBLE_SLOT;
        }
        else if(icCardSlot >=0) {
            sc.slot = SlotCard.CONTACT_SLOT;
            sc.cardType = icCardSlot;
        }
        else {
            sc.slot = SlotCard.CONTACTLESS_SLOT;
            sc.cardType = rfCardSlot;
        }
        return sc;
    }

    private int ifCardInSlot(byte[] data) {
        if(icReader != null) {
            int r = icReader.open(defaultReaderNo, null);
            if(r < 0) {
                return -2;
            }
            r = icReader.powerOn(defaultReaderNo, data);
            if(r <= 0) {
                icReader.powerOff(defaultReaderNo);
                icReader.close();
                return -2;
            }
            int cardType = icReader.getCardType(defaultReaderNo);
            if((cardType >= 0 && cardType <= 6) || cardType == 256) {
                //Log.d("在接触插槽发现卡，类型：", cardType+"");
            }
            icReader.powerOff(defaultReaderNo);
            return cardType;
        } else {
            return -1;
        }
    }

    private int ifCardOnContactlessSlot(byte[] data) {
        if(rfReader != null) {
            int r = rfReader.open();
            if(r < 0) {
                //Log.d("非接触错误", "open");
                return -2;
            }
            r = rfReader.waitForCard(1000);
            if(r != 0) {
                //Log.d("非接触错误", "waitForCard");
                return -2;
            }
            int ret = rfReader.powerOn(data);
            if(ret <= 0) {
                //Log.d("非接触错误", "powerOn");
                rfReader.powerOff();
                rfReader.close();
                return -2;
            }
            int cardType = rfReader.getCardType();
            if((cardType >= 0 && cardType <=9) || cardType == 0x0100) {
                //Log.d("在非接触插槽发现卡，类型：", cardType+"");
            }
            rfReader.powerOff();
            rfReader.close();
            return cardType;
        } else {
            return -1;
        }
    }

    /**
     * 一次通信交互
     * @param s
     * @param ret
     * @return
     */
    private int oneRound(int r, String s, byte[] ret){
        //Log.d("发送的数据：", s);
        byte[] b = StringUtility.StringToByteArray(s);
        int len;
        if(r == 0) {
            len = rfReader.transmit(b, ret);
        } else {
            len = icReader.transmit(defaultReaderNo, b, ret);
        }
        //Log.d("读取的数据：", StringUtility.ByteArrayToString(ret, len));
        if(len < 0) {
            return len;
        }
        return len;
    }

    /**
     * 如果是射频卡，返回0
     * 是CPU卡，返回1
     * 错误，返回小于0的值
     * @return int结果
     */
    private int isCPU() {
        SlotCard sc = findTheSlotThatHasCardOn();
        if(sc.slot < 0) {
            return sc.slot;
        }
        if(sc.slot == SlotCard.CONTACT_SLOT && sc.cardType == SmartCardReader.CONTACT_CARD_TYPE_A_CPU) {
            return 1;
        }
        if(sc.slot == SlotCard.CONTACTLESS_SLOT && sc.cardType == 0) {
            return 0;
        }
        return -1;
    }

    /**
     * prelude of every Primeton invocation
     * @return int结果
     */
    public int prelude() {
        int r = isCPU();
        if(r < 0) {
            return -9999;
        }

        if(openDevice(r) < 0) {
            return -9998;
        }

        // zt specific
        byte[] ret = new byte[64];
        String cmd = "00A404000E325041592E5359532E4444463031";
        if(r == 1) {
            cmd =    "00A404000E315041592E5359532E44444630310000";
        }
        int n = oneRound(r, cmd, ret);
        if (n < 0) {
            return -1;
        }
        if (n > 2 && ret[n - 2] == 97) {
            n = oneRound(r, "00C00000" + StringUtility.ByteArrayToString(ret, n - 1, 1), ret);
            if (n < 0) {
                return -1;
            }
        }
        return r;
    }

    /**
     * lightweight wrapper for BlueRW readRfCard
     * @param rc ReadCard对象
     * @return int结果
     */
    public int readCard(ReadCard rc) {
        int r = prelude();
        if(r < 0) {
            return r;
        }

        blueRW.icReader = this.icReader;
        blueRW.rfReader = this.rfReader;
        blueRW.defaultReaderNo = this.defaultReaderNo;
        blueRW.isRfOrCpu = r;
        int n = blueRW.readRfCard(rc);
        closeDevice(r);
        return n;
    }

    /**
     * 打开设备
     * @param ic
     * @return
     */
    private int openDevice(int ic) {
        byte[] data=new byte[256];
        if(ic == 0) {
            int r = rfReader.open();
            if(r < 0) {
                //Log.d("非接触错误", "open");
                return -2;
            }
            r = rfReader.waitForCard(1000);
            if(r != 0) {
                //Log.d("非接触错误", "waitForCard");
                return -2;
            }
            int ret = rfReader.powerOn(data);
            if(ret <= 0) {
                //Log.d("非接触错误", "powerOn");
                rfReader.powerOff();
                rfReader.close();
                return -2;
            }
            return 0;
        } else {
            int r = icReader.open(defaultReaderNo, null);
            if(r < 0) {
                return -2;
            }
            r = icReader.powerOn(defaultReaderNo, data);
            if(r <= 0) {
                icReader.powerOff(defaultReaderNo);
                icReader.close();
                return -2;
            }
            return 0;
        }
    }

    /**
     * 关闭设备
     * @param r
     */
    private void closeDevice(int r) {
        if (r == 0) {
            rfReader.powerOff();
            rfReader.close();
        } else {
            icReader.powerOff(defaultReaderNo);
            icReader.close();
        }
    }


    /**
     * 写卡
     * @param rc 读卡参数
     * @param wc 写卡参数
     * @return int 结果
     */
    public int writeCard(ReadCard rc, WriCard wc) {
        int r = prelude();
        if(r < 0) {
            return r;
        }

        blueRW.icReader = this.icReader;
        blueRW.rfReader = this.rfReader;
        blueRW.defaultReaderNo = this.defaultReaderNo;
        blueRW.isRfOrCpu = r;
        int n = blueRW.writeRfCard(rc, wc);
        closeDevice(r);
        return n;
    }

    /**
     * 清卡
     * @param rc 读卡参数
     * @param wc 写卡参数
     * @return int结果
     */
    public int clearCard(ReadCard rc, WriCard wc) {
        int r = prelude();
        if(r < 0) {
            return r;
        }

        blueRW.icReader = this.icReader;
        blueRW.rfReader = this.rfReader;
        blueRW.defaultReaderNo = this.defaultReaderNo;
        blueRW.isRfOrCpu = r;
        int n = blueRW.clearRfCard(rc, wc);
        closeDevice(r);
        return n;
    }

}
