package com.af.plugins;

import org.apache.poi.hwpf.HWPFDocument;
import org.json.JSONObject;
import org.springframework.util.ClassUtils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class WordTools {
    /**
     * 将数据生成到word中
     */
    public static String saveWord(String filename, JSONObject data) throws IOException {
        if( filename.split("\\.")[1] == "docx"){
            return "";
        }

        String filepathString = ClassUtils.getDefaultClassLoader().getResource("/word//"+filename).getPath();
        String downString = filepathString.replace("word","excel");
        // String filepathString = resource.getPath();
        Iterator<String> it = data.keySet().iterator();
        HashMap<String, String> map = new HashMap<>();
        while(it.hasNext()){
            String key = it.next();
            Object obj = data.get(key);
            String value = "";
            if(obj instanceof Integer){
                value = Integer.toString((Integer) obj);
            }else if(data.get(key) instanceof String){
                value = (String)obj;
            }else{
                obj = "";
                value =(String)obj;
            }
            key = key.replace("_","");
            key = "#{"+key+"}";
            map.put(key,value);
        }

        //目的目录
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String savePath = XwpfTUtil.getPath("contractFilepath");
        File file = new File(savePath + File.separator + format.format(new Date()));
        //判断上传文件的保存目录是否存在
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
        filename = filename.split("\\.")[0]+Long.toString(new Date().getTime())+".doc";
        String destpathString =file.getAbsolutePath() + File.separator + filename;
        System.out.println("当前保存的路径!!!!!!!===>"+destpathString);
        boolean bol = XwpfTUtil.replaceAndGenerateWord(filepathString,destpathString, map);

        if(bol){
            return destpathString;
        }
        return "";
    }

    /**
     * 将生成的word文档保存,以便下载使用
     * @param filename
     * @param filepath
     * @return
     */
    public static String saveDownPath(String filename,String filepath){
        try {
            String filepathString = ClassUtils.getDefaultClassLoader().getResource("/word//"+filename).getPath();
            String downString = filepathString.substring(0, filepathString.lastIndexOf("WEB-INF"));
            downString = downString+"/word";
            File file = new File(downString);
            if(!file.exists()){
                file.mkdir();
            }
            downString = downString+"/"+filename;
            HWPFDocument document = new HWPFDocument(new FileInputStream(filepath));
            FileOutputStream outStream = null;
            outStream = new FileOutputStream(downString);
            document.write(outStream);
            outStream.close();
            return downString;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 将word文档转为html返回
     * @param filename
     * @return
     * @throws Exception
     */
    public static String gethtml(String filename) throws Exception {
        String descfilename = filename.substring(0, filename.lastIndexOf("doc"))+"html";
        String descpath = XwpfTUtil.docxToHtml(filename, descfilename);
        //String result = XwpfTUtil.readfile(descpath);
        File file = new File(descpath);
        FileInputStream fi = new FileInputStream(file);
        byte [] b = new byte[1024];
        int len = 0;
        StringBuilder sb = new StringBuilder();
        while(-1 != (len = fi.read(b))) {
            String s = new String(b,"utf8");
            sb.append(s);
        }
        return sb.toString();
    }

}
