package com.af.plugins;

import cn.hutool.core.net.URLEncoder;
import com.aote.ThreadResource;
import com.aote.config.SystemConfig;
import com.aote.logic.SpringBeansPour;
import com.aote.rs.mapper.WebException;
import com.aote.transaction.ClientSession;
import com.aote.transaction.SessionPool;
import com.aote.util.JsonHelper;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.*;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

/**
 * REST风格请求插件
 */
public class RestTools implements SpringBeansPour {

	private ClientSession clientSession;

	@Override
	public void initBeans(ApplicationContext applicationContext) {
		clientSession = applicationContext.getBean(ClientSession.class);
	}

	/**
	 * 发送通用Http请求
	 * @param path  请求路径
	 * @param value 请求参数
	 * @param headers 请求头
	 * @param base  请求类型
	 * @return  请求结果
	 */
	public static String request(String path, String value, String headers, HttpRequestBase base){
		if (!path.startsWith("http")) {
			// 从系统配置中获得path对应的地址
			path = SystemConfig.System.getProxyUrl()+path;
		}
		try {
			JSONObject headerJson;
			if(headers == null || "".equals(headers)){
				headerJson = new JSONObject();
			} else {
				headerJson = new JSONObject(headers);
			}
			if(!headerJson.has("Content-Type")){
				//指定请求参数的数据格式是JSON。
				headerJson.put("Content-Type", "application/json");
			}
			headerJson.put("appToken", "db4afb0c04ab4af0b5626998fe7c9b21");

			return HttpConnectionPoolUtil.request(path, value, headerJson.toString(), base);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 发送通用Http请求
	 * @param path  请求路径
	 * @param value 请求参数
	 * @param headers 请求头
	 * @param base  请求类型
	 * @return  请求结果
	 */
	public static void requestPostFile(String path, String value, String headers, HttpEntityEnclosingRequestBase base, HttpConnectionPoolUtil.HttpEntityAction action){
		if (!path.startsWith("http")) {
			// 从系统配置中获得path对应的地址
			path = SystemConfig.System.getProxyUrl()+path;
		}
		try {
			JSONObject headerJson;
			if(headers == null || "".equals(headers)){
				headerJson = new JSONObject();
			} else {
				headerJson = new JSONObject(headers);
			}
			if(!headerJson.has("Content-Type")){
				//指定请求参数的数据格式是JSON。
				headerJson.put("Content-Type", "application/json");
			}
			HttpConnectionPoolUtil.requestMetaData(path, value, headerJson.toString(), base, action);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 发送post请求
	 *
	 * @param path    请求路径
	 * @param value   请求体
	 * @param headers  请求头
	 * @return String结果
	 */
	public static String post(String path, String value, String headers) {
		return request(path, value, headers, new HttpPost());
	}
	public static String post(String path, JSONObject value, JSONObject headers) {
		if(value == null){
			return post(path, null, headers.toString());
		} else {
			return post(path, value.toString(), headers.toString());
		}
	}
	public static String post(String path, JSONObject value) {
		return post(path, value.toString(), null);
	}
	public static String post(String path, String value) {
		return post(path, value, null);
	}
	public static String post(String path){
		return post(path, "",null);
	}
	public static String postheader(String path, String value) {
		JSONObject headers = new JSONObject();
		headers.put("Content-Type", "application/json");
		headers.put("appToken", "db4afb0c04ab4af0b5626998fe7c9b21");
		return request(path,value,headers.toString(),new HttpPost());
	}
	public static void postHttpEntity(String path, JSONObject value, HttpConnectionPoolUtil.HttpEntityAction action) {
		JSONObject headers = new JSONObject();
		headers.put("Content-Type", "application/json");
		headers.put("appToken", "db4afb0c04ab4af0b5626998fe7c9b21");
		requestPostFile(path,value.toString(),headers.toString(),new HttpPost(), action);
	}

	/**
	 * 发送get请求
	 * @param path	请求路径
	 * @param headers 请求头
	 * @return String结果
	 */
	public static String get(String path, String headers) {
		return request(path, null, headers, new HttpGet());
	}
	public static String get(String path, JSONObject headers){
		return get(path, headers.toString());
	}
	public static String get(String path) {
		return get(path, "");
	}


	/**
	 * 发送getJson请求
	 *
	 * @param path	请求路径
	 * @return json对象
	 */
	public static JSONObject getJson(String path) {
		return getJson(path, null);
	}
	public static JSONObject getJson(String path, JSONObject headers) {
		String requestResult = get(path, headers.toString());
		Object resultObj;
		if (requestResult.startsWith("{")) {
			resultObj = new JSONObject(requestResult);
		} else if (requestResult.startsWith("[")) {
			resultObj = new JSONArray(requestResult);
		} else {
			throw new RuntimeException("调用rest服务失败。");
		}
		JSONObject result = new JSONObject();
		result.put("code", 200);
		result.put("data", resultObj);
		return result;
	}

	/**
	 * 发送put请求
	 *
	 * @param path	请求路径
	 * @param value	请求参数
	 * @param headers 请求头
	 * @return String结果
	 */
	public static String put(String path,String value,String headers){
		return request(path, value, headers, new HttpPut());
	}
	public static String put(String path,JSONObject value,JSONObject headers){
		if(value == null){
			return put(path, null, headers.toString());
		} else {
			return put(path, value.toString(), headers.toString());
		}
	}
	public static String put(String path, String value){
		return put(path,value,"");
	}
	public static String put(String path, JSONObject value){
		return put(path,value.toString(),"");
	}
	public static String put(String path){
		return put(path,"",null);
	}

	/**
	 * 发送delete请求
	 *
	 * @param path	请求路径
	 * @param value	请求参数
	 * @param headers 请求头
	 * @return String结果
	 */
	public static String delete(String path,String value,String headers){
		return request(path, value, headers, new HttpDeleteWithBody());
	}
	public static String delete(String path,JSONObject value,JSONObject headers){
		if(value == null){
			return delete(path, null, headers.toString());
		} else {
			return delete(path, value.toString(), headers.toString());
		}
	}
	public static String delete(String path,String value){
		return delete(path,value,"");
	}
	public static String delete(String path,JSONObject value){
		return delete(path,value.toString(),"");
	}
	public static String delete(String path) {
		return delete(path, "",null);
	}

	/**
	 * 执行给定action
	 *
	 * @param param	参数列表
	 * @return json对象
	 */
	public Object action(JSONObject param) {
		String url = param.getString("url");
		String data = param.getString("data");

		// 如果线程中有session内容，调用session传播
		String actual;
		Integer id = ThreadResource.SessionId.get();
		if (id != null) {
			// session传播
			int toId = SessionPool.getInstance().createCallSession(id, url);
			// 把活动的sessionid发送过去
			JSONObject headers = new JSONObject();
			headers.put("session", toId + "");
			headers.put("appToken", "db4afb0c04ab4af0b5626998fe7c9b21");
			actual = post(url, new JSONObject(data), headers);
		} else if ( null != clientSession && clientSession.sessionId != null && clientSession.sessionId != "") {
			// 启动了客户端事务，把客户端事务sessionId添加到请求头中
			JSONObject headers = new JSONObject();
			headers.put("session", clientSession.sessionId);
			headers.put("appToken", "db4afb0c04ab4af0b5626998fe7c9b21");

			actual = post(url, new JSONObject(data), headers);
		} else {
			actual = post(url, data);
		}

		// 返回结果
		JSONObject result = new JSONObject();
		result.put("code", 200);
		// 有可能是错误码
		if(actual.startsWith("{")) {
			JSONObject actualJson = new JSONObject(actual);
			// 如果不是数据，返回错误内容
			if (actualJson.has("status")) {
				result.put("code", actualJson.get("status"));
				result.put("data", actualJson.getString("data"));
			} else {
				result.put("data", actualJson);
			}
		}
		else if(actual.startsWith("[")) {
			result.put("data", new JSONArray(actual));
		} else {
			result.put("data", actual);
		}
		return result;
	}

	/**
	 * REST请求路径拼接参数
	 *
	 * @param url   请求路径
	 * @param params 请求参数
	 * @return String结果
	 */
	public static String formatURL(String url, JSONObject params) {
		//设置表单长度30字节*N个请求参数
		int capacity = params.length() * 30;
		//拼接请求路径
		StringBuilder buffer = new StringBuilder(capacity);
		buffer.append(url).append("?");
		//取出JSON里面的请求参数，添加到路径中。
		Iterator<String> keys = params.keys();
		while (keys.hasNext()){
			String key = keys.next();
			String val = String.valueOf(params.get(key));
			if(!"".equals(val)){
				buffer.append(key).append("=").append(val);
			} else {
				buffer.append(key);
			}
			if(keys.hasNext()){
				buffer.append("&");
			}
		}
		return buffer.toString();
	}

	/**
	 * REST请求路径拼接参数
	 *
	 * @param url   请求路径
	 * @param params 请求参数
	 * @return String结果
	 */
	public static String formatAndEncodeURL(String url, JSONObject params) {
		String urlStr = formatURL(url, params);
		return urlStr.substring(0,urlStr.indexOf("?") + 1) + URLEncoder.QUERY.encode(urlStr.substring(urlStr.indexOf("?") + 1), StandardCharsets.UTF_8);
	}

	/**
	 * 获取标准格式的请求路径
	 * @param protocolType 协议类型（http,https,ftp...）
	 * @param url 请求ip,域名
	 * @param port 端口，默认80
	 * @param paramStr 需要拼接的路径
	 * @return 标准格式的请求路径
	 */
	public static String getStandardURL(String protocolType,String url,String port,String paramStr){
		if (port == null){
			port = "80";
		}
		url = protocolType+"://"+url+":"+port;
		if(paramStr != null){
			url += paramStr;
		}
		return url;
	}
}
