package com.af.plugins;

import org.json.JSONArray;
import org.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportTools {


    public static void main(String[] args) {
        ArrayList list = new ArrayList<>();
        Map<Object,Object> map = new HashMap<>();
        map.put("f_sale_money",13.5);
        list.add(map);
        double x = getSum(list);
    }
    /**
     *
     * @param list
     * @return JsonArray
     */
    public static JSONArray getJsonArray (ArrayList list){
        System.out.println(list);
        JSONArray jsonArray = new JSONArray(list);
        return jsonArray;
    }


    /**
     *
     * @param list
     * @return int 费用合计
     */
    public static double getSum(ArrayList list){
        double sum = 0;
        for(Object obj : list) {
            Map map = (Map)obj;
            Double saleMoney =  new Double( map.get("f_sale_money").toString());
            sum+=saleMoney;
        }
        return sum;
    }
    /**
     *
     * @param jsonArray
     * @return int 费用合计
     */
    public static double getSum(JSONArray jsonArray){
        double sum = 0;
        for(Object obj : jsonArray) {
            JSONObject jsonObject = (JSONObject)obj;
            Double saleMoney =  new Double( jsonObject.get("f_sale_money").toString());
            sum+=saleMoney;
        }
        return sum;
    }

    /**
     * 数字金额大写转换，思想先写个完整的然后将如零拾替换成零 要用到正则表达式
     */
    public static String digitUppercase(JSONArray jsonArray) {
        double n = getSum(jsonArray);
        return  toUppercase(n);
    }

    /**
     * 数字金额大写转换，思想先写个完整的然后将如零拾替换成零 要用到正则表达式
     */
    public static String digitUppercase(ArrayList list) {
        double n = getSum(list);
        return  toUppercase(n);
    }

    public static String toUppercase(double n){
        String fraction[] = { "角", "分"};
        String digit[] = { "零", "壹", "贰", "叁", "肆", "伍", "陆", "柒", "捌", "玖"};
        String unit[][] = { { "元", "万", "亿"}, { "", "拾", "佰", "仟"}};

        String head = n < 0 ? "负" : "";
        n = Math.abs(n);

        String s = "";
        for (int i = 0; i < fraction.length; i++) {
            s += (digit[(int) (Math.floor(n * 10 * Math.pow(10, i)) % 10)] + fraction[i]).replaceAll("(零.)+", "");
        }
        if (s.length() < 1) {
            s = "整";
        }
        int integerPart = (int) Math.floor(n);

        for (int i = 0; i < unit[0].length && integerPart > 0; i++) {
            String p = "";
            for (int j = 0; j < unit[1].length && n > 0; j++) {
                p = digit[integerPart % 10] + unit[1][j] + p;
                integerPart = integerPart / 10;
            }
            s = p.replaceAll("(零.)*零$", "").replaceAll("^$", "零") + unit[0][i] + s;
        }
        return head + s.replaceAll("(零.)*零元", "元").replaceFirst("(零.)+", "").replaceAll("(零.)+", "零").replaceAll("^整$", "零元整");
    }
}
