package com.af.plugins;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import com.alibaba.fastjson.JSONObject;
import org.json.JSONArray;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * small tools method
 *
 * @author zhaotong
 *
 */
public class CommonTools {
	/**
	 * 获取一个类的实例
	 * @param className 类名（com.af.plugins.CommonTools）
	 * @param param 构造方法参数
	 * @return 实例
	 */
	public static Object getInstance(String className,JSONArray param){
		Class<?> classInstance;
		try {
			//加载类
			classInstance = Class.forName(className);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		if(param != null && param.length()>0){
			//参数数组
			Object[] objects = new Object[param.length()];
			//参数类型数组
			Class<?>[] paramClasses = new Class[param.length()];
			for(int i=0;i<param.length();i++){
				//获取参数
				objects[i] = param.get(i);
				//获取参数类型
				Class<?> clazz = objects[i].getClass();
				try {
					//如果是基本数据类型
					Field f = clazz.getDeclaredField("TYPE");
					paramClasses[i] = ((Class<?>) f.get(null));
				} catch (NoSuchFieldException e) {
					//如果是类类型
					paramClasses[i] = clazz;
				} catch (IllegalAccessException e) {
					throw new RuntimeException(e);
				}
			}
			//根据构造方法获取实例
			try {
				Constructor<?> constructor = classInstance.getDeclaredConstructor(paramClasses);
				constructor.setAccessible(true);
				return constructor.newInstance(objects);
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		} else {
			try {
				Constructor<?> constructor = classInstance.getDeclaredConstructor();
				constructor.setAccessible(true);
				return constructor.newInstance();
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		}
	}

	/**
	 *  获取一个类的实例（无参）
	 *  @param className 类名（com.af.plugins.CommonTools）
	 *  @return 实例
	 */
	public static Object getInstance(String className){
		return getInstance(className, null);
	}

	/**
	 * 获取一个UUID
	 * @param isSimple 为true时，UUID没有“-”分隔
	 * @return UUID字符串
	 */
	public static String getUUID(Boolean isSimple){
		return UUID.fastUUID().toString(isSimple);
	}

	/**
	 * 获取一个用“-”分隔的UUID
	 * @return UUID字符串
	 */
	public static String getUUID(){
		return getUUID(false);
	}

	/**
	 * MD5加密
	 * @param param 需要加密的参数
	 * @return MD5加密后的字符串
	 */
	public static String md5(String param) {
		return MD5.create().digestHex(param);
	}

	/**
	 * 获取一个指定范围的伪随机数
	 * @param min 最小值(包含)
	 * @param max 最大值(包含)
	 * @return 伪随机数
	 */
	public static int getRandomNumber(Integer min,Integer max){
		return RandomUtil.randomInt(min,max+1);
	}

	/**
	 * 判断传入字符是否为数字
	 * @param str
	 * @return
	 */
	public static boolean isNumeric(String str) {
		try {
			new BigDecimal(str);
		} catch (Exception e) {
			e.printStackTrace();
			//异常 说明包含非数字。
			return false;
		}
		return true;
	}

	/**
	 * 将字符串类型转换为Double
	 * @return enum
	 * @param param 构造方法参数
	 */
	public static Double stringToDouble(String param){
		return Double.valueOf(param);
	}

	// 判断参数是否包含字母
	public static boolean judgeContainsStr(String cardNum) {
		String regex = ".*[a-zA-Z]+.*";
		Matcher m = Pattern.compile(regex).matcher(cardNum);
		return m.matches();
	}

	// 判断包含有数字和字母的字符串，在最后一个字母之后的第一个非零数字的索引
	public static int indexNumber(String value) {
		char[] ch = value.toCharArray();
		int result = 0;
		for (int i = indexCharacter(value) + 1; i < ch.length; i++) {
			if (ch[i] != 0) {
				result = i;
				break;
			}
		}
		return result;
	}

	// 判断包含有数字和字母的字符串中，最后一个字母出现的位置的索引
	public static int indexCharacter(String value) {
		char[] ch = value.toCharArray();
		int flag = 0;
		for (int i = ch.length - 1; i >= 0; i--) {
			if (ch[i] < '0' || ch[i] > '9') {
				flag = i;
				break;
			}
		}
		System.out.println(flag);
		return flag;
	}

	// 给定包含有字母和数字的字符串区间生成所有范围值，用于地址和表号的批量生成
	/**
	 * @return 集合
	 * @param value example:"1,2" or "A01001,A01010"
	 */
	public static List<String> getStringBatch(String value) {

		List<String> list = new ArrayList<>();

		if (value.contains(",")) {
			String start = value.split(",")[0];
			String end = value.split(",")[1];
			if (!CommonTools.judgeContainsStr(start)
					&& !CommonTools.judgeContainsStr(end)) {
				String format = "%0" + end.length() + "d";
				for (int i = Integer.parseInt(start); i <= Integer
						.parseInt(end); i++) {
					list.add(String.valueOf(String.format(format, i)));
				}
			} else if (CommonTools.judgeContainsStr(start)
					&& CommonTools.judgeContainsStr(end)) {

				String format = "%0"
						+ String.valueOf(end.length()
								- (CommonTools.indexCharacter(end) + 1)) + "d";
				String str = end.substring(0,
						CommonTools.indexCharacter(end) + 1);
				for (int i = getNumber(start); i <= getNumber(end); i++) {
					list.add(str + String.format(format, i));
				}

			} else {
				System.out.println("data error");
			}

		} else {
			list.add(value);
		}

		return list;
	}

	private static int getNumber(String value) {
		return Integer.parseInt(value.substring(
				CommonTools.indexNumber(value) + 1));
	}

	/**
	 * 字符串加1操作，，目前只支持加1，
	 *
	 * @param a 字符串a
	 * @param b 字符串b
	 * @return 字符串
     * @throws Exception 异常
	 */
	public static String strAdd(String a, int b) throws Exception{

		String result;
		if (a.length() == 1) {
			try{
				return Integer.parseInt(a) + 1 + "";
			}catch(Exception e) {
				throw new Exception("编号" + a + "不能加一");
			}
		}
		// 获取前一半
		String first = a.substring(0,a.length()/2);
		// 截取一半
		String last = a.substring(a.length() / 2);
		// 后半部分加一之后
		int temp = Integer.parseInt(last) + 1;
		StringBuilder sb = new StringBuilder();

		if (Integer.toString(temp).length() <= last.length()) {
			// 用零不全
			for (int i = 0; i < (last.length() - Integer.toString(temp).length()); i++) {
				sb.append("0");
			}
			result = first + sb + temp;

		} else {
			for (int i = 0; i< last.length(); i++) {
				sb.append("0");
			}
			first = new Integer(first) + 1 + "";

			result = first + sb;
		}

		return result;

	}

	/**
	 * 精确加法运算
	 * @param o1 被加数
	 * @param o2 加数
	 * @return 和
	 */
	public static BigDecimal add(Object o1, Object o2) {
		if(o1 instanceof String || o2 instanceof String){
			return NumberUtil.add(String.valueOf(o1),String.valueOf(o2));
		} else {
			return NumberUtil.add((Number) o1,(Number) o2);
		}
	}

	/**
	 * 精确加法运算(带精度)
	 * WARN：对目标按照精度直接进行截取，即向下舍入操作
	 * @param scale 精度
	 * @param o1 被加数
	 * @param o2 加数
	 * @return 和
	 */
	public static BigDecimal add(Object o1, Object o2, int scale) {
		if (scale < 0) {
			throw new IllegalArgumentException("精度不能小于0");
		}
		BigDecimal result = add(o1, o2);
		return result.setScale(scale, BigDecimal.ROUND_DOWN);
	}

	/**
	 * 精确减法运算
	 * @param o1 被减数
	 * @param o2 减数
	 * @return 差
	 */
	public static BigDecimal sub(Object o1, Object o2) {
		if(o1 instanceof String || o2 instanceof String){
			return NumberUtil.sub(String.valueOf(o1),String.valueOf(o2));
		} else {
			return NumberUtil.sub((Number) o1,(Number) o2);
		}
	}

	/**
	 * 精确减法运算 可以传入精度
	 * WARN：对目标按照精度直接进行截取，即向下舍入操作
	 * @param scale 精度
	 * @param o1 被减数
	 * @param o2 减数
	 * @return 差
	 */
	public static BigDecimal sub(Object o1, Object o2, int scale) {
		if (scale < 0) {
			throw new IllegalArgumentException("精度不能小于0");
		}
		BigDecimal result = sub(o1, o2);
		return result.setScale(scale, BigDecimal.ROUND_DOWN);
	}

	/**
	 * 精确乘法运算
     * @param o1 被乘数
     * @param o2 乘数
     * @return 积
	 */
	public static BigDecimal mul(Object o1, Object o2) {
		if(o1 instanceof String || o2 instanceof String){
			return NumberUtil.mul(String.valueOf(o1),String.valueOf(o2));
		} else {
			return NumberUtil.mul((Number) o1,(Number) o2);
		}
	}

	/**
	 * 精确乘法运算 可以传入精度
	 * WARN：对目标按照精度直接进行截取，即向下舍入操作
	 * @param scale 精度
	 * @param o1 被乘数
	 * @param o2 乘数
	 * @return 积
	 */
	public static BigDecimal mul(Object o1, Object o2, int scale) {
		if (scale < 0) {
			throw new IllegalArgumentException("精度不能小于0");
		}
		BigDecimal result = mul(o1, o2);
		return result.setScale(scale, BigDecimal.ROUND_DOWN);
	}

	/**
	 * 提供(相对)精确的除法运算,当发生除不尽的情况的时候,精确到小数点后10位,后面的四舍五入
     * @param o1 被除数
     * @param o2 除数
     * @return 两个参数的商
	 */
	public static BigDecimal div(Object o1, Object o2) {
		return div(o1,o2,10);
	}

	/**
	 * 提供(相对)精确的除法运算,当发生除不尽的情况时,由scale指定精确度,后面的四舍五入
     * @param o2  对象
     * @param o1  对象
     * @return  double类型的结果集
     * @param scale 精度
	 */
	public static BigDecimal div(Object o1, Object o2, int scale) {
		if (scale < 0) {
			throw new IllegalArgumentException("精度不能小于0");
		}
		if(o1 instanceof String || o2 instanceof String){
			return NumberUtil.div(String.valueOf(o1),String.valueOf(o2),scale);
		} else {
			return NumberUtil.div((Number) o1,(Number) o2,scale);
		}
	}

	/**
	 * 字符串分割
     * @param str 字符串
     * @param separator 以什么方式分割
     * @return JSONArray 集合
	 */
	public static JSONArray split(String str, String separator) {
		return new JSONArray(StrUtil.split(str,separator));
	}

	/**
	 * Url参数转Json
	 * @param urlParams url参数
	 * @return JSONObject
	 */
	public static JSONObject url2json(String urlParams){
		JSONObject result = new JSONObject();
		String[] split = urlParams.split("&");
		for(String entry : split){
			String[] mapEntry = entry.split("=");
			String value = mapEntry.length > 1 ? mapEntry[1] : "";
			result.put(mapEntry[0], value);
		}
		return result;
	}

	/**
	 * 截取字符串
	 * @param str 字符串
	 * @param start 从什么地方开始
	 * @param end 到什么地方结束
	 * @return 截取好的字符串
	 */
	public static String substring(String str, int start, int end) {
		return str.substring(start, end);
	}

	/**
	 * 指定字符串是否在字符串中出现过
	 *
	 * @param str       字符串
	 * @param searchStr 被查找的字符串
	 * @return 是否包含
	 */
	public static boolean isContains(String str, String searchStr) {
		return StrUtil.contains(str,searchStr);
	}

	/**
	 * 将两个字符串按逗号拼接
     * @param str1 字符串1
     * @param str2  字符串2
     * @return 拼接好的字符串
	 */
	public static String union(String str1, String str2) {
		// 全空返回空
		if ("".equals(str1) && "".equals(str2)) {
			return "";
		}
		if (!"".equals(str1) && "".equals(str2)) {
			return str1;
		}
		if ("".equals(str1) && !"".equals(str2)) {
			return str2;
		}

		// 两个都不为空，返回逗号连接的字符串
		return str1 + "," + str2;
	}

	/**
	 * 合并一个JSON数组里的所有字符串，形式为：'a','b'
     * @param array 传入一个json数组
     * @return 合并后的字符串
	 */

	public static String union(JSONArray array) {
		StringBuilder result = new StringBuilder();
		array.forEach(item -> result.append("'").append(item).append("',"));
		result.deleteCharAt(result.length()-1);
		return result.toString();
	}

	public static String union(JSONArray array,String column) {
		StringBuilder result = new StringBuilder();
		array.forEach(item -> {
			JSONObject itemObject = (JSONObject) item;
			//system.out.println(itemObject);
			result.append("'").append(itemObject.get(column)).append("',");
		});
		result.deleteCharAt(result.length()-1);
		return result.toString();
	}

	/**
	 * 格式化参数字符串
	 * @param str 需要格式化的参数字符串，格式：http://{baseUrl}/rs/logic/{logicName}
	 * @param parametricMap 参数映射字典，如：baseUrl: baidu.com , logicName: beta
	 * @return 格式化后的参数字符串，结果：http://baidu.com/rs/logic/beta
	 */
	public static String parametricStr(String str, Map parametricMap){
		boolean isReplace = str.contains("{") && str.contains("}");
		if(isReplace){
			char[] strArray = str.toCharArray();
			StringBuilder replaceStr = new StringBuilder();
			do {
				int start = str.indexOf("{");
				int end = str.indexOf("}");
				//获得需要被替换的key
				for (int i = start + 1; i < end; i++) {
					replaceStr.append(strArray[i]);
				}
				//读取根据key映射字典的值
				String param = String.valueOf(parametricMap.get(replaceStr.toString()));
				//替换字符
				if(!param.equals("null")) {
					str = str.replace("{" + replaceStr + "}", param);
					//清空缓存
					replaceStr.setLength(0);
					strArray = str.toCharArray();
					//重新判断
					isReplace = start != -1 && end != -1;
				} else {
					return str;
				}
			} while (isReplace);
		}
		return str;
	}
}
