/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.office;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.apache.poi.xwpf.converter.core.BasicURIResolver;
import org.apache.poi.xwpf.converter.core.FileImageExtractor;
import org.apache.poi.xwpf.converter.core.IImageExtractor;
import org.apache.poi.xwpf.converter.core.IURIResolver;
import org.apache.poi.xwpf.converter.core.Options;
import org.apache.poi.xwpf.converter.xhtml.XHTMLConverter;
import org.apache.poi.xwpf.converter.xhtml.XHTMLOptions;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.w3c.dom.Document;

public class DocUtil {
    public static String docxToHtml(String rootPath, String fileUrl) throws IOException {
        File folder2;
        String docName = fileUrl.substring(0, fileUrl.lastIndexOf("."));
        String htmlName = docName + ".html";
        String imagePath = rootPath + "/image/" + docName;
        String htmlUrl = rootPath + htmlName;
        FileInputStream input = new FileInputStream(rootPath + fileUrl);
        XWPFDocument document = new XWPFDocument((InputStream)input);
        File imgFolder = new File(imagePath);
        XHTMLOptions options = XHTMLOptions.create();
        options.setExtractor((IImageExtractor)new FileImageExtractor(imgFolder));
        options.URIResolver((IURIResolver)new BasicURIResolver("image/" + docName));
        options.setIgnoreStylesIfUnused(false);
        options.setFragment(true);
        File folder = new File(htmlUrl);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(folder2 = new File(imagePath)).exists()) {
            folder2.mkdirs();
        }
        File htmlFile = new File(htmlUrl);
        FileOutputStream out = new FileOutputStream(htmlFile);
        XHTMLConverter.getInstance().convert(document, (OutputStream)out, (Options)options);
        return htmlUrl;
    }

    public static void main(String[] args) throws IOException {
        DocUtil.docToHtml("D:/a/", "\u65b0\u5efa DOC \u6587\u6863.doc");
        DocUtil.docxToHtml("D:/a/", "40-iES-CMR\u4e0e\u5965\u67ab\u8425\u6536\u7cfb\u7edf\u5bf9\u63a5\u6587\u6863.docx");
    }

    public static String docToHtml(String rootPath, String fileUrl) {
        FileInputStream input = null;
        final String docName = fileUrl.substring(0, fileUrl.lastIndexOf("."));
        String htmlName = docName + ".html";
        String htmlUrl = rootPath + htmlName;
        String imagePath = rootPath + "/image/" + docName + "/word/media/";
        File folder = new File(imagePath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            input = new FileInputStream(rootPath + fileUrl);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        HWPFDocument wordDocument = null;
        try {
            wordDocument = new HWPFDocument((InputStream)input);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        WordToHtmlConverter wordToHtmlConverter = null;
        try {
            wordToHtmlConverter = new WordToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        wordToHtmlConverter.setPicturesManager(new PicturesManager(){

            public String savePicture(byte[] content, PictureType pictureType, String suggestedName, float widthInches, float heightInches) {
                return "/image/" + docName + "/word/media/" + suggestedName;
            }
        });
        wordToHtmlConverter.processDocument((HWPFDocumentCore)wordDocument);
        List pics = wordDocument.getPicturesTable().getAllPictures();
        for (Object o : pics) {
            Picture pic = (Picture)o;
            try {
                pic.writeImageContent((OutputStream)new FileOutputStream(imagePath + docName + "_" + pic.suggestFullFileName()));
            }
            catch (IOException e) {
                e.fillInStackTrace();
            }
        }
        Document htmlDocument = wordToHtmlConverter.getDocument();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        DOMSource domSource = new DOMSource(htmlDocument);
        StreamResult streamResult = new StreamResult(outStream);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = null;
        try {
            serializer = tf.newTransformer();
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        serializer.setOutputProperty("encoding", "utf-8");
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("method", "html");
        try {
            serializer.transform(domSource, streamResult);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        try {
            outStream.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String content = new String(outStream.toByteArray());
        try {
            FileUtils.writeStringToFile((File)new File(htmlUrl), (String)content, (String)"utf-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return htmlUrl;
    }
}

