/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.calculate;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class PriceDateFormatTools {
    static final NumberFormat NF = NumberFormat.getInstance();

    public static void formatNumber(JSONObject object) {
        Iterator iterator = object.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = object.get(key);
            if (value instanceof BigDecimal) {
                object.put(key, (Object)PriceDateFormatTools.formatNumberBase((BigDecimal)value));
                continue;
            }
            if (value instanceof JSONObject) {
                PriceDateFormatTools.formatNumber((JSONObject)value);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            PriceDateFormatTools.formatNumber((JSONArray)value);
        }
    }

    public static void formatNumber(JSONArray object) {
        Iterator iterator = object.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value instanceof BigDecimal) {
                object.put(index, (Object)PriceDateFormatTools.formatNumberBase((BigDecimal)value));
            } else if (value instanceof JSONObject) {
                PriceDateFormatTools.formatNumber((JSONObject)value);
            } else if (value instanceof JSONArray) {
                PriceDateFormatTools.formatNumber((JSONArray)value);
            }
            ++index;
        }
    }

    public static String formatNumberBase(BigDecimal value) {
        return NF.format(value);
    }

    static {
        NF.setGroupingUsed(false);
        NF.setMinimumFractionDigits(2);
        NF.setMaximumFractionDigits(4);
    }
}

