/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.bank;

import com.aote.rs.mapper.WebException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class jsonToTCP {
    private JSONObject cfg;
    private String requestType;
    private String message;

    public JSONObject jsontotcp(JSONObject data, String requestType, JSONObject cfg) {
        this.requestType = requestType;
        this.cfg = cfg;
        String requestData = this.getRequestData(data);
        this.send(requestData);
        return this.getResult();
    }

    private String getRequestData(JSONObject data) {
        StringBuilder result = new StringBuilder();
        String[][] requesCfg = this.getCfg("requestData", 6);
        for (int i = 0; i < requesCfg.length; ++i) {
            String[] datscfg = requesCfg[i];
            result.append(this.padding(switch (datscfg[2]) {
                case "constant" -> datscfg[3];
                case "length" -> this.getLength(requesCfg, datscfg[3], 1);
                case "variable" -> data.getString(datscfg[0]);
                case "transition" -> this.getTransition(datscfg[0], data.getString(datscfg[0]));
                default -> throw new WebException(500, this.requestType + "\u4e2drequestData\u7ec4\u7ec7\u7c7b\u578b\u5f02\u5e38" + (i + 1));
            }, datscfg[1], datscfg[4], datscfg[5]));
        }
        return result.toString();
    }

    private void send(String requestData) {
        System.out.println(requestData);
        String result = "";
        try {
            Socket socket = new Socket(this.cfg.getString("path"), this.cfg.getInt("port"));
            OutputStream out = socket.getOutputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.write(requestData.getBytes("GBK"));
            out.flush();
            System.out.println(in.readLine());
            result = in.readLine();
            out.close();
            in.close();
            socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.message = result;
    }

    private JSONObject getResult() {
        JSONObject result = new JSONObject();
        String site = this.cfg.getString("resultStatus");
        String succeed = this.cfg.getString("succeed");
        String[][] resultCfg = succeed.equals(this.getStringByMessage(site)) ? this.getCfg("resultOK", 4) : this.getCfg("resultNO", 4);
        block22: for (int i = 0; i < resultCfg.length; ++i) {
            String[] datscfg = resultCfg[i];
            String dResult = switch (datscfg[2]) {
                case "constant" -> datscfg[3];
                case "variable" -> this.getStringByMessage(datscfg[3]);
                case "transition" -> this.getTransition(datscfg[1], this.getStringByMessage(datscfg[3]));
                default -> throw new WebException(500, this.requestType + "\u4e2drequestData\u7ec4\u7ec7\u7c7b\u578b\u5f02\u5e38" + (i + 1));
            };
            switch (datscfg[0]) {
                case "long": {
                    result.put(datscfg[1], Long.parseLong(dResult));
                    continue block22;
                }
                case "int": {
                    result.put(datscfg[1], Integer.parseInt(dResult));
                    continue block22;
                }
                case "double": {
                    result.put(datscfg[1], Double.parseDouble(dResult));
                    continue block22;
                }
                case "boolean": {
                    result.put(datscfg[1], Boolean.parseBoolean(dResult));
                    continue block22;
                }
                default: {
                    result.put(datscfg[1], (Object)dResult);
                }
            }
        }
        return result;
    }

    private String[][] getCfg(String type, int leng) {
        try {
            JSONArray array = this.cfg.getJSONObject(this.requestType).getJSONArray(type);
            String[][] result = new String[array.length()][leng];
            for (int i = 0; i < array.length(); ++i) {
                String[] datscfg = array.getString(i).split("=");
                if (datscfg.length != leng) {
                    throw new WebException(500, this.requestType + "\u4e2d" + type + "\u914d\u7f6e\u53c2\u6570\u5f02\u5e38,\u6761\u76ee : " + (i + 1));
                }
                result[i] = datscfg;
            }
            return result;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private String padding(String data, String Size, String site, String filler) {
        StringBuilder result = new StringBuilder();
        result.append(data);
        int size = Integer.parseInt(Size);
        int dataLength = data.length();
        if (dataLength < size) {
            for (int i = 0; i < size - dataLength; ++i) {
                if ("right".equals(site)) {
                    result.append(filler);
                    continue;
                }
                result.insert(0, filler);
            }
        }
        if (result.length() != size) {
            throw new WebException(500, "\u6570\u636e\u957f\u5ea6\u5f02\u5e38\uff0c\u6570\u636e :" + data + ",\u914d\u7f6e\u957f\u5ea6:" + Size + ",\u5b9e\u9645\u957f\u5ea6:" + result.length());
        }
        return result.toString();
    }

    private String getLength(String[][] datscfg, String dSite, int site) {
        String[] siteArr = dSite.split("-");
        int result = 0;
        int begin = "begin".equals(siteArr[0]) ? 0 : Integer.parseInt(siteArr[0]) - 1;
        int end = "end".equals(siteArr[1]) ? datscfg.length : Integer.parseInt(siteArr[1]);
        for (int i = begin; i < end; ++i) {
            result += Integer.parseInt(datscfg[i][site]);
        }
        return String.valueOf(result);
    }

    private String getTransition(String type, String key) {
        return this.cfg.getJSONObject("transition").getJSONObject(type).getString(key);
    }

    private String getStringByMessage(String site) {
        String[] siteArr = site.split("-");
        int begin = "begin".equals(siteArr[0]) ? 0 : Integer.parseInt(siteArr[0]) - 1;
        int end = "end".equals(siteArr[1]) ? this.message.length() : Integer.parseInt(siteArr[1]);
        return this.message.substring(begin, end);
    }
}

