/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugins;

import com.aote.logic.LogicMapper;
import com.aote.logic.LogicServer;
import com.aote.report.ReportMapper;
import com.aote.sql.SqlMapper;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilialeReplace {
    static Logger log = Logger.getLogger(FilialeReplace.class);
    @Autowired
    private LogicServer logicServer;

    public static void logicReplace(String filiale) {
        try {
            log.debug((Object)("\u5206\u516c\u53f8logic\u66ff\u6362===>" + filiale));
            String str = filiale + File.separator + "logic.xml";
            InputStream moduleLogic = LogicMapper.class.getClassLoader().getResourceAsStream(str);
            if (moduleLogic == null) {
                throw new RuntimeException("\u627e\u4e0d\u5230\u5206\u516c\u53f8logic\u914d\u7f6e\u6587\u4ef6\uff1a" + str);
            }
            SAXReader reader = new SAXReader();
            Document docLogic = reader.read(moduleLogic);
            Element rootLogic = docLogic.getRootElement();
            Iterator item = rootLogic.elementIterator("logic");
            while (item.hasNext()) {
                Element elmment = (Element)item.next();
                String aliasLogic = elmment.attribute("alias").getValue();
                String pathLogic = elmment.attribute("path").getValue();
                String log = elmment.attributeValue("log");
                String mobile = elmment.attributeValue("mobile");
                String path = filiale + File.separator + "logics" + File.separator + pathLogic;
                HashMap<String, Object> logic = new HashMap<String, Object>();
                logic.put("alias", aliasLogic);
                logic.put("path", path);
                logic.put("log", log);
                logic.put("mobile", mobile);
                FilialeReplace.log.debug((Object)("alias:" + aliasLogic + "===>path:" + path));
                LogicMapper.getMap().put(aliasLogic, logic);
            }
        }
        catch (Exception e) {
            log.debug((Object)("\u5206\u516c\u53f8logic\u66ff\u6362\u5f02\u5e38===>" + e));
        }
    }

    public static void sqlReplace(String filiale) {
        try {
            log.debug((Object)("\u5206\u516c\u53f8sql\u66ff\u6362===>" + filiale));
            String str = filiale + File.separator + "sql.xml";
            InputStream moduleLogic = LogicMapper.class.getClassLoader().getResourceAsStream(str);
            if (moduleLogic == null) {
                throw new RuntimeException("\u627e\u4e0d\u5230\u5206\u516c\u53f8sql\u914d\u7f6e\u6587\u4ef6\uff1a" + str);
            }
            SAXReader reader = new SAXReader();
            Document docLogic = reader.read(moduleLogic);
            Element rootLogic = docLogic.getRootElement();
            Iterator item = rootLogic.elementIterator("sql");
            while (item.hasNext()) {
                Element elmment = (Element)item.next();
                String aliasLogic = elmment.attribute("alias").getValue();
                String pathLogic = elmment.attribute("path").getValue();
                String mobile = elmment.attributeValue("mobile");
                String path = filiale + File.separator + "sqls" + File.separator + pathLogic;
                HashMap<String, Object> logic = new HashMap<String, Object>();
                logic.put("alias", aliasLogic);
                logic.put("path", path);
                logic.put("mobile", mobile);
                log.debug((Object)("alias:" + aliasLogic + "===>path:" + path));
                SqlMapper.getMap().put(aliasLogic, logic);
            }
        }
        catch (Exception e) {
            log.debug((Object)("\u5206\u516c\u53f8sql\u66ff\u6362\u5f02\u5e38===>" + e));
        }
    }

    public static void reportReplace(String filiale) {
        try {
            log.debug((Object)("\u5206\u516c\u53f8report\u66ff\u6362===>" + filiale));
            String str = filiale + File.separator + "report.xml";
            InputStream moduleLogic = LogicMapper.class.getClassLoader().getResourceAsStream(str);
            if (moduleLogic == null) {
                throw new RuntimeException("\u627e\u4e0d\u5230\u5206\u516c\u53f8report\u914d\u7f6e\u6587\u4ef6\uff1a" + str);
            }
            SAXReader reader = new SAXReader();
            Document docLogic = reader.read(moduleLogic);
            Element rootLogic = docLogic.getRootElement();
            Iterator item = rootLogic.elementIterator("report");
            while (item.hasNext()) {
                Element elmment = (Element)item.next();
                String aliasLogic = elmment.attribute("alias").getValue();
                String pathLogic = elmment.attribute("path").getValue();
                String path = "/" + filiale + File.separator + "reports" + File.separator + pathLogic;
                log.debug((Object)("alias:" + aliasLogic + "===>path:" + path));
                ReportMapper.getReport().put(aliasLogic, path);
            }
        }
        catch (Exception e) {
            log.debug((Object)("\u5206\u516c\u53f8report\u66ff\u6362\u5f02\u5e38===>" + e));
        }
    }

    public void redisCache() {
        try {
            this.logicServer.redisCacheLogic();
        }
        catch (Exception e) {
            log.debug((Object)"\u91cd\u65b0\u52a0\u8f7d\u6a21\u5757\u5230readis\u5f02\u5e38", (Throwable)e);
        }
    }
}

