/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugins;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.json.JSONArray;
import org.json.JSONObject;

public class FileTool {
    public JSONArray getChild(String rootPath) {
        File[] childArr;
        rootPath = rootPath.trim().replace("\\", "/").replace("/", File.separator);
        JSONArray fileArr = new JSONArray();
        File file = new File(rootPath);
        for (File child : childArr = file.listFiles()) {
            JSONObject json = new JSONObject();
            if (child.isDirectory()) {
                json.put("size", 1);
                json.put("suffix", (Object)"");
                json.put("type", (Object)"\u6587\u4ef6\u5939");
                json.put("name", (Object)child.getName());
            } else {
                if (child.getName().indexOf(".") == -1) {
                    json.put("suffix", (Object)"");
                    json.put("name", (Object)child.getName());
                } else {
                    json.put("suffix", (Object)child.getName().substring(child.getName().lastIndexOf(".") + 1));
                    json.put("name", (Object)child.getName().substring(0, child.getName().lastIndexOf(".")));
                }
                json.put("size", 0);
                json.put("type", (Object)"\u6587\u4ef6");
            }
            json.put("id", (Object)child.getPath());
            fileArr.put((Object)json);
        }
        fileArr = this.jsonArrOrder(fileArr);
        return fileArr;
    }

    private JSONArray jsonArrOrder(JSONArray data) {
        int i;
        JSONArray sortedJsonArray = new JSONArray();
        ArrayList<JSONObject> jsonValues = new ArrayList<JSONObject>();
        for (i = 0; i < data.length(); ++i) {
            jsonValues.add(data.getJSONObject(i));
        }
        Collections.sort(jsonValues, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject a, JSONObject b) {
                if (!a.getString("type").equals(b.getString("type"))) {
                    if (a.getString("type").equals("\u6587\u4ef6\u5939")) {
                        return -1;
                    }
                    return 1;
                }
                return a.getString("name").compareTo(b.getString("name"));
            }
        });
        for (i = 0; i < data.length(); ++i) {
            sortedJsonArray.put(jsonValues.get(i));
        }
        return sortedJsonArray;
    }

    public boolean deletetByPath(String path) {
        File file = new File(path = path.trim().replace("\\", "/").replace("/", File.separator));
        if (!file.exists()) {
            return false;
        }
        if (!file.isDirectory()) {
            return file.delete();
        }
        File[] childList = file.listFiles();
        if (childList.length == 0) {
            return file.delete();
        }
        for (File p : childList) {
            if (this.deletetByPath(p.getPath())) continue;
            return false;
        }
        return file.delete();
    }

    public boolean createFolderByPath(String path) {
        File file = new File(path = path.trim().replace("\\", "/").replace("/", File.separator));
        if (!file.exists()) {
            file.mkdirs();
            return file.exists();
        }
        return false;
    }

    public boolean createFileByPath(String path) {
        File file = new File(path = path.trim().replace("\\", "/").replace("/", File.separator));
        if (!file.exists()) {
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(path));
                bw.close();
                return file.exists();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean changeNameByPath(String path, String newName) {
        path = path.trim().replace("\\", "/").replace("/", File.separator);
        if ("".equals(newName = ((String)newName).trim()) || newName == null || ((String)newName).indexOf("/") != -1 || ((String)newName).indexOf("\\") != -1) {
            return false;
        }
        File file = new File(path);
        if (!file.exists()) {
            return false;
        }
        newName = path.substring(0, path.lastIndexOf(File.separator) + 1) + (String)newName;
        File newFile = new File((String)newName);
        if (newFile.exists()) {
            return false;
        }
        try {
            file.renameTo(newFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean copyByPath(String sourcePath, String targetPath) {
        sourcePath = sourcePath.trim().replace("\\", "/").replace("/", File.separator);
        targetPath = targetPath.trim().replace("\\", "/").replace("/", File.separator);
        try {
            File sourceFile = new File(sourcePath);
            if (!sourceFile.exists()) {
                return false;
            }
            new File(targetPath).mkdirs();
            if (sourceFile.isFile()) {
                File targetFile = new File(targetPath + File.separator + sourceFile.getName());
                FileTool.copyFile(sourceFile, targetFile);
            }
            if (sourceFile.isDirectory()) {
                String targetDir = targetPath + File.separator + sourceFile.getName();
                FileTool.copyDirectiory(sourcePath, targetDir);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static void copyFile(File sourceFile, File targetFile) throws IOException {
        int len;
        FileInputStream input = new FileInputStream(sourceFile);
        BufferedInputStream inBuff = new BufferedInputStream(input);
        FileOutputStream output = new FileOutputStream(targetFile);
        BufferedOutputStream outBuff = new BufferedOutputStream(output);
        byte[] b = new byte[5120];
        while ((len = inBuff.read(b)) != -1) {
            outBuff.write(b, 0, len);
        }
        outBuff.flush();
        inBuff.close();
        outBuff.close();
        output.close();
        input.close();
    }

    private static void copyDirectiory(String sourceDir, String targetDir) throws IOException {
        new File(targetDir).mkdirs();
        File[] sourceFile = new File(sourceDir).listFiles();
        for (int i = 0; i < sourceFile.length; ++i) {
            if (sourceFile[i].isFile()) {
                File targetFile = new File(new File(targetDir).getAbsolutePath() + File.separator + sourceFile[i].getName());
                FileTool.copyFile(sourceFile[i], targetFile);
            }
            if (!sourceFile[i].isDirectory()) continue;
            String dir1 = sourceDir + File.separator + sourceFile[i].getName();
            String dir2 = targetDir + File.separator + sourceFile[i].getName();
            FileTool.copyDirectiory(dir1, dir2);
        }
    }
}

