/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import com.af.plugins.ConvertTools;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageData {
    private String name;
    private int width;
    private int height;
    private String base64Str;
    private String imageType;

    public static ImageData getImageData(String path) throws IOException {
        File picture = new File(path);
        String fileName = picture.getName();
        String prefix = fileName.substring(fileName.lastIndexOf(".") + 1);
        BufferedImage sourceImg = ImageIO.read(new FileInputStream(picture));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)sourceImg, prefix, out);
        byte[] source = out.toByteArray();
        ImageData result = new ImageData();
        result.name = fileName;
        result.imageType = prefix;
        result.width = sourceImg.getWidth();
        result.height = sourceImg.getHeight();
        result.base64Str = ConvertTools.base64Encode(source);
        return result;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getBase64Str() {
        return this.base64Str;
    }

    public void setBase64Str(String base64Str) {
        this.base64Str = base64Str;
    }

    public String getImageType() {
        return this.imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

