/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugins.impexp.exportfile;

import com.aote.path.PathServer;
import com.aote.plugins.impexp.exportfile.IExportFile;
import com.aote.sql.SqlServer;
import com.aote.util.ExcelUtil;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class ExportFilePlus
implements IExportFile {
    private JSONObject map = null;
    private double exportspeed = 0.0;
    private static final int MAX_ROWS_PER_SHEET = 1001;
    private static final int MAX_SELECT_LEN = 101;
    private static final String defaultCondition = "{orderitem: 'id',condition: '1=1'}";
    static Logger log = Logger.getLogger(ExportFilePlus.class);
    @Autowired
    private DataSource dataSource;
    @Autowired
    private PathServer pathServer;
    @Autowired
    private SqlServer sqlServer;

    @Override
    public JSONArray export(String condition, String configName) throws Exception {
        if (condition == null || "".equals(condition)) {
            return new JSONArray();
        }
        return this.noTemplate(condition);
    }

    @Override
    public JSONArray export(String condition, String configName, Session session) throws Exception {
        return null;
    }

    private JSONArray noTemplate(String condition) throws Exception {
        JSONArray result = new JSONArray();
        JSONObject json = new JSONObject();
        long tick = System.currentTimeMillis();
        JSONObject jsonObject = new JSONObject(condition);
        String filepath = this.getFilePath(new JSONObject(condition).getString("templateName") + ".xlsx");
        json.put("filename", (Object)filepath);
        result.put((Object)json);
        if (new JSONObject(condition).has("sqlName")) {
            this.export(new JSONObject(condition).getString("sqlName"), condition, null, filepath);
        } else if (new JSONObject(condition).has("pathName")) {
            this.exportpath(new JSONObject(condition).getString("pathName"), condition, null, filepath);
        }
        tick = System.currentTimeMillis() - tick;
        System.out.println("\u8fdb\u884cExcel\u5bfc\u51fa\u8017\u65f6\uff1a" + (double)tick / 1000.0 + "\u79d2");
        System.out.println("\u6587\u4ef6\u540d\uff1a" + result);
        return result;
    }

    private String getFilePath(String name) {
        String excelFileName = name == null ? UUID.randomUUID() + ".xlsx" : name;
        String path = ExcelUtil.class.getClassLoader().getResource("config.json").getPath();
        String rootPath = path.split("WEB-INF")[0];
        String filePath = rootPath + "excel/" + excelFileName;
        return filePath;
    }

    private void export(String name, String body, String templateName, String filePath) throws Exception {
        int datalen;
        if (templateName != null) {
            log.warn((Object)"\u6682\u65f6\u4e0d\u652f\u6301\u6a21\u677f\u5bfc\u51fa");
            return;
        }
        this.exportspeed = 0.0;
        BigDecimal bg = null;
        JSONArray rs = null;
        ExcelUtil eu = null;
        String[][] footer = null;
        eu = new ExcelUtil();
        eu.createBook(null, filePath);
        JSONObject joParam = new JSONObject(body);
        if (joParam.has("total")) {
            footer = this.getFooter(joParam.getJSONArray("total"));
        }
        JSONObject exportlen = this.sqlServer.queryTotal(name, body);
        int alllen = datalen = ((Integer)exportlen.get("n")).intValue();
        System.out.println("\u672c\u6b21\u5bfc\u51fa\u6570\u91cf" + datalen);
        JSONArray exportdata = new JSONArray();
        if (datalen > 1000 && datalen % 1000 > 0) {
            for (int i = 0; i < datalen / 1000; ++i) {
                for (int j = 0; j < 10; ++j) {
                    int sqlpage = 0;
                    sqlpage = i == 0 ? j + 1 : 10 * i + (j + 1) * i;
                    rs = this.sqlServer.query(name, sqlpage, 100, body);
                    exportdata = this.concatJsonArray(exportdata, rs);
                    bg = new BigDecimal((double)rs.length() / ((double)alllen * 1.0) + this.exportspeed);
                    this.exportspeed = bg.setScale(2, 4).doubleValue();
                }
                this.exportWithHedear(eu, joParam, exportdata, footer, false);
                exportdata = new JSONArray();
            }
            int olresetlen = datalen / 1000 * 10;
            datalen -= datalen / 1000 * 1000;
            exportdata = new JSONArray();
            if (datalen > 100) {
                int resetlen = 0;
                resetlen = datalen > 100 * (datalen / 100) ? datalen / 100 + 1 : datalen / 100;
                for (int i = 0; i < resetlen; ++i) {
                    rs = this.sqlServer.query(name, olresetlen + i + 1, 100, body);
                    exportdata = this.concatJsonArray(exportdata, rs);
                    bg = new BigDecimal((double)rs.length() / ((double)alllen * 1.0) + this.exportspeed);
                    this.exportspeed = bg.setScale(2, 4).doubleValue();
                    if (i != resetlen - 1) continue;
                    this.exportWithHedear(eu, joParam, exportdata, footer, true);
                }
            } else {
                rs = this.sqlServer.query(name, olresetlen + 1, 100, body);
                bg = new BigDecimal((double)rs.length() / ((double)alllen * 1.0) + this.exportspeed);
                this.exportspeed = bg.setScale(2, 4).doubleValue();
                this.exportWithHedear(eu, joParam, rs, footer, true);
            }
        } else if (datalen > 100) {
            int resetlen = 0;
            resetlen = datalen > 100 * (datalen / 100) ? datalen / 100 + 1 : datalen / 100;
            for (int i = 0; i < resetlen; ++i) {
                rs = this.sqlServer.query(name, i + 1, 100, body);
                bg = new BigDecimal((double)rs.length() / ((double)alllen * 1.0) + this.exportspeed);
                this.exportspeed = bg.setScale(2, 4).doubleValue();
                exportdata = this.concatJsonArray(exportdata, rs);
                if (i != resetlen - 1) continue;
                this.exportWithHedear(eu, joParam, exportdata, footer, true);
            }
        } else {
            rs = this.sqlServer.query(name, body, Integer.valueOf(-1));
            bg = new BigDecimal((double)rs.length() / ((double)alllen * 1.0) + this.exportspeed);
            this.exportspeed = bg.setScale(2, 4).doubleValue();
            this.exportWithHedear(eu, joParam, rs, footer, true);
        }
    }

    @Override
    public double getExportspeed() {
        return this.exportspeed;
    }

    public JSONArray concatJsonArray(JSONArray src, JSONArray des) {
        JSONArray result = new JSONArray();
        for (Object item : src) {
            result.put(item);
        }
        for (Object item : des) {
            result.put(item);
        }
        return result;
    }

    private void exportpath(String name, String body, String templateName, String filePath) throws Exception {
        JSONObject joParam = new JSONObject(body);
        String[][] footer = null;
        if (joParam.has("total")) {
            JSONArray totals = joParam.getJSONArray("total");
            footer = this.getFooter(totals);
        }
        JSONObject joVariable = joParam.getJSONObject("data");
        JSONArray result = this.pathServer.query(name, joParam.toString());
        try {
            this.exportWithHedearpath(filePath, joParam, result, footer);
        }
        catch (Exception e) {
            log.error((Object)("\u5bfc\u51fa\u6587\u4ef6: " + name + "\u51fa\u9519\uff0c\u539f\u56e0 \uff1a" + e.getMessage()));
        }
    }

    private String[][] getFooter(JSONArray totals) {
        int n = totals.length();
        String[][] footer = new String[n][];
        for (int i = 0; i < n; ++i) {
            JSONObject jo = totals.getJSONObject(i);
            String[] names = JSONObject.getNames((JSONObject)jo);
            Arrays.sort(names, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return Integer.parseInt(o1) - Integer.parseInt(o2);
                }
            });
            footer[i] = new String[names.length];
            for (int j = 0; j < names.length; ++j) {
                footer[i][j] = jo.isNull(names[j]) ? null : jo.get(names[j]) + "";
            }
        }
        return footer;
    }

    private void exportWithHedear(String filePath, JSONObject joParam, String sql, ResultSet rs, String[][] footer) throws Exception, SQLException {
        Object object;
        int n;
        boolean fromHbm = false;
        boolean isSum = false;
        String[][] newHeader = null;
        if (joParam.has("header")) {
            JSONArray headerArray = joParam.getJSONArray("header");
            n = headerArray.length();
            newHeader = new String[n][];
            this.jsonToTwoArr(newHeader, headerArray, n);
        }
        if (joParam.has("footer")) {
            JSONArray footerArray = joParam.getJSONArray("footer");
            n = footerArray.length();
            String[][] footerth = new String[n][];
            this.jsonToTwoArr(footerth, footerArray, n);
            footer = footerth;
        }
        JSONArray joField = joParam.getJSONArray("field");
        if (joParam.has("sumName") && (object = joParam.get("sumName")) instanceof JSONArray) {
            JSONArray sumName = (JSONArray)object;
            isSum = true;
        }
        List sumNames = null;
        BigDecimal[] sum = null;
        if (isSum) {
            JSONArray sumName = joParam.getJSONArray("sumName");
            sumNames = sumName.toList();
        }
        LinkedHashMap<String, String> colsMap = new LinkedHashMap<String, String>();
        this.findOutHeaders(joField, colsMap);
        String[] header = colsMap.values().toArray(new String[colsMap.size()]);
        String[] cols = colsMap.keySet().toArray(new String[colsMap.size()]);
        ExcelUtil eu = new ExcelUtil();
        eu.createBook(null, filePath);
        int n2 = 1;
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        if (isSum) {
            sum = new BigDecimal[colsMap.size()];
        }
        while (rs.next()) {
            int i;
            if (n2 % 1001 == 0) {
                eu.createSheet();
                n2 = 1;
                eu.writeToSheet(rows, header, footer, newHeader);
                rows = new ArrayList();
            }
            ArrayList<Object> fieldList = new ArrayList<Object>();
            if (fromHbm) {
                fieldList.add(rs.getObject("id"));
            }
            int n3 = i = fromHbm ? 1 : 0;
            while (i < colsMap.size()) {
                Object object2 = rs.getObject(cols[i]);
                if (sumNames != null && sum != null) {
                    if (sumNames.contains(cols[i])) {
                        if (sum[i] == null) {
                            BigDecimal num2;
                            sum[i] = num2 = new BigDecimal(String.valueOf(object2));
                        } else {
                            BigDecimal num1 = new BigDecimal(String.valueOf(sum[i]));
                            BigDecimal num2 = new BigDecimal(String.valueOf(object2));
                            sum[i] = num1.add(num2);
                        }
                    } else {
                        sum[i] = null;
                    }
                }
                fieldList.add(object2);
                ++i;
            }
            rows.add(fieldList);
            ++n2;
        }
        if (sum != null) {
            List<BigDecimal> sums = Arrays.asList(sum);
            rows.add(sums);
        }
        if (n2 > 1) {
            eu.createSheet();
            eu.writeToSheet(rows, header, footer, newHeader);
        }
        eu.saveBook();
    }

    private void jsonToTwoArr(String[][] newHeader, JSONArray headerArray, int n) {
        for (int i = 0; i < n; ++i) {
            JSONArray array = headerArray.getJSONArray(i);
            int p = array.length();
            newHeader[i] = new String[p];
            for (int j = 0; j < p; ++j) {
                newHeader[i][j] = String.valueOf(array.get(j));
            }
        }
    }

    private void exportWithHedear(ExcelUtil eu, JSONObject joParam, JSONArray array, String[][] footer, boolean isexport) throws Exception, SQLException {
        JSONArray sumName;
        Object object;
        boolean fromHbm = false;
        boolean isSum = false;
        JSONArray joField = joParam.getJSONArray("field");
        if (joParam.has("sumName") && (object = joParam.get("sumName")) instanceof JSONArray) {
            sumName = (JSONArray)object;
            isSum = true;
        }
        List sumNames = null;
        BigDecimal[] sum = null;
        if (isSum) {
            sumName = joParam.getJSONArray("sumName");
            sumNames = sumName.toList();
        }
        LinkedHashMap<String, String> colsMap = new LinkedHashMap<String, String>();
        this.findOutHeaders(joField, colsMap);
        String[] header = colsMap.values().toArray(new String[colsMap.size()]);
        String[] cols = colsMap.keySet().toArray(new String[colsMap.size()]);
        int n = 1;
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        if (isSum) {
            sum = new BigDecimal[colsMap.size()];
        }
        for (Object item : array) {
            int i;
            JSONObject objectItem = (JSONObject)item;
            if (n % 1001 == 0) {
                eu.createSheet();
                n = 1;
                eu.writeToSheet(rows, header, footer);
                rows = new ArrayList();
            }
            ArrayList<Object> fieldList = new ArrayList<Object>();
            if (fromHbm) {
                fieldList.add(objectItem.get("id"));
            }
            int n2 = i = fromHbm ? 1 : 0;
            while (i < colsMap.size()) {
                Object object2 = objectItem.get(cols[i]);
                if (sumNames != null && sum != null) {
                    if (sumNames.contains(cols[i])) {
                        if (sum[i] == null) {
                            BigDecimal num2;
                            sum[i] = num2 = new BigDecimal(String.valueOf(object2));
                        } else {
                            BigDecimal num1 = new BigDecimal(String.valueOf(sum[i]));
                            BigDecimal num2 = new BigDecimal(String.valueOf(object2));
                            sum[i] = num1.add(num2);
                        }
                    } else {
                        sum[i] = null;
                    }
                }
                fieldList.add(object2);
                ++i;
            }
            rows.add(fieldList);
            ++n;
        }
        if (sum != null) {
            List<BigDecimal> sums = Arrays.asList(sum);
            rows.add(sums);
        }
        if (n > 1) {
            eu.createSheet();
            eu.writeToSheet(rows, header, footer);
        }
        if (isexport) {
            eu.saveBook();
        }
    }

    private void findOutHeaders(JSONArray joField, Map<String, String> headers) {
        for (Object temp : joField) {
            String col = ((String)temp).split(":")[0];
            headers.put(col, ((String)temp).split(":")[1]);
        }
    }

    private void exportWithTemplate(String templateName, String filePath, ResultSet rs, String[][] footer) throws Exception {
        ExcelUtil eu = new ExcelUtil();
        eu.createBook(templateName, filePath);
        int nCol = rs.getMetaData().getColumnCount();
        int n = 1;
        ArrayList rows = new ArrayList();
        while (rs.next()) {
            if (n % 1001 == 0) {
                eu.createSheet();
                n = 1;
                eu.writeToSheet(rows, null, footer);
                rows = new ArrayList();
            }
            ArrayList<Object> fieldList = new ArrayList<Object>();
            for (int i = 1; i <= nCol; ++i) {
                Object object = rs.getObject(i);
                fieldList.add(object);
            }
            rows.add(fieldList);
            ++n;
        }
        if (n > 1) {
            eu.createSheet();
            eu.writeToSheet(rows, null, footer);
        }
        eu.saveBook();
    }

    private void exportWithHedearpath(String filePath, JSONObject joParam, JSONArray jsonarry, String[][] footer) throws Exception, SQLException {
        int n;
        JSONArray joField = joParam.getJSONArray("field");
        LinkedHashMap<String, String> colsMap = new LinkedHashMap<String, String>();
        this.findOutHeaders(joField, colsMap);
        String[] header = colsMap.values().toArray(new String[colsMap.size()]);
        String[] cols = colsMap.keySet().toArray(new String[colsMap.size()]);
        ExcelUtil eu = new ExcelUtil();
        eu.createBook(null, filePath);
        log.error((Object)("\u6570\u636e\u957f\u5ea6\u662f: " + jsonarry.length()));
        ArrayList rows = new ArrayList();
        for (n = 1; n <= jsonarry.length(); ++n) {
            if (n % 1001 == 0) {
                eu.createSheet();
                n = 1;
                eu.writeToSheet(rows, header, footer);
                rows = new ArrayList();
            }
            ArrayList<Object> fieldList = new ArrayList<Object>();
            for (int i = 0; i < colsMap.size(); ++i) {
                Object object = this.getSObject(jsonarry.getJSONObject(n - 1), cols[i]);
                fieldList.add(object);
            }
            rows.add(fieldList);
        }
        if (n > 1) {
            eu.createSheet();
            eu.writeToSheet(rows, header, footer);
        }
        eu.saveBook();
    }

    private Object getSObject(JSONObject obj, String filestr) {
        Object result = null;
        try {
            String[] strArray = filestr.split("\\.");
            result = obj;
            for (int i = 0; i < strArray.length; ++i) {
                result = this.getSValue((JSONObject)result, strArray[i]);
            }
        }
        catch (Exception e) {
            log.error((Object)("\u89e3\u6790\u5bf9\u8c61\u51fa\u9519: " + obj.toString() + "\u51fa\u9519\uff0c" + filestr + "\u539f\u56e0 \uff1a" + e.getMessage()));
        }
        if (result instanceof JSONObject) {
            result = "";
        }
        return result;
    }

    private Object getSValue(JSONObject obj, String res) {
        Object result = null;
        try {
            if (obj != null) {
                String copy = res;
                if (copy.indexOf("[") > -1 && copy.indexOf("]") > -1) {
                    String intflag = copy.substring(res.indexOf("[") + 1, copy.lastIndexOf("]"));
                    if (intflag.length() > 0) {
                        String prop = res.substring(0, res.indexOf("["));
                        result = obj.has(prop) ? obj.getJSONArray(prop).get(Integer.parseInt(intflag)) : null;
                    }
                } else {
                    result = obj.get(res);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("\u89e3\u6790\u5bf9\u8c61\u51fa\u9519: " + obj.toString() + "\u51fa\u9519\uff0c" + res + "\u539f\u56e0 \uff1a" + e.getMessage()));
        }
        return result;
    }
}

