/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugins;

import com.af.plugins.JsonTools;
import com.aote.ThreadResource;
import com.aote.logic.LogicServer;
import com.aote.workflow.plugin.WorkFlowLogicServer;
import org.json.JSONObject;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkFlowTools {
    @Autowired
    private LogicServer logicServer;
    private static final WorkFlowLogicServer workFlowLogicServer = new WorkFlowLogicServer();

    public void runWork(String filePath) throws Exception {
        JSONObject jsonObject = JsonTools.readJsonFile(filePath);
        ThreadResource.ComponentDir.set(jsonObject.get("organization").toString());
        String id = workFlowLogicServer.startWorkflow(jsonObject.getString("workflow_xmlfilename"));
        for (Object next : jsonObject.getJSONArray("workflow")) {
            this.runOneLogic((JSONObject)next, new JSONObject("{f_process_id:" + id + "}"));
            String str = workFlowLogicServer.getWait(id);
            Assert.assertEquals((Object)((JSONObject)next).getString("assert"), (Object)str);
        }
    }

    public String runOneLogic(JSONObject json, JSONObject addParam) throws Exception {
        JSONObject param = json.getJSONObject("param");
        JsonTools.addJSON(param, addParam);
        return this.logicServer.run(json.getString("name"), param.toString()).toString();
    }
}

