package com.af.plugins.kafka.kafka_producer;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
* kafka单实例多线程模式生产者发送消息
*
* @author 王泽松
* @date 2019-5-9 am 11:13
*
*/
public class KafkaProducerSendMessage {
    private static ExecutorService executor = Executors.newCachedThreadPool();

    /**
     * 多线程单实例发消息
     * @param topic 选择发送消息的话题
     * @param message 发送的消息内容
     * @param partitionNum 该话题的分区数
     */
    public static void sendMessageSingleton(String topic, String message, int partitionNum){
        executor.submit(new HandlerProducer1(topic, partitionNum, message));
    }

    /**
     * 多线程多实例模式发消息
     * @param topic 选择发送消息的话题
     * @param message 发送的消息内容
     * @param partitionNum 该话题的分区数
     * */
    public static void sendMessageThreads(String topic, String message, int partitionNum) {
        executor.submit(new HandlerProducer1(topic, partitionNum, message));
    }

    public static void shutdownExecute() {
        executor.shutdown();
    }
}
