package com.af.plugins;

import com.aote.sql.SqlServer;
import org.hibernate.internal.SessionFactoryImpl;
import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.util.*;
import java.util.Map.Entry;

/**
 * SQL语句处理工具类，动态生成复杂update语句，等等
 * 
 * @author zt
 *
 */
public class SqlTools {

	/**
	 * 本函数为动态生成sql更新语句（目前支持单表），目前支持postgresql
	 *
	 * @param tablename 表名
	 * @param obj 需要更新的参数
	 * @param condition 执行更新的条件，传入条件
	 * @return 返回程序生成的sql语句
	 * @throws Exception 异常
	 */
	public static String getUpdateSql(String tablename, JSONObject obj, String condition) throws Exception {
		String sql = "update " + tablename + " set ";
		String sqlCondition = "where " + condition;
		Map<String, Object> map = JsonTools.toHashMap(obj);
		StringBuilder sqlpart = new StringBuilder();
		for (Entry<String, Object> enty : map.entrySet()) {
			String str;
			if (enty.getValue() instanceof Integer
					|| enty.getValue() instanceof Double
					|| enty.getValue() instanceof BigDecimal
					|| enty.getValue() instanceof Boolean
					|| enty.getValue() == null) {
				str = enty.getKey() + "=" + enty.getValue() + ",";
			} else {
				str = enty.getKey() + "='" + enty.getValue() + "',";
			}
			sqlpart.append(str);
		}
		sqlpart = new StringBuilder(sqlpart.substring(0, sqlpart.length() - 1) + " ");
		return sql + sqlpart + sqlCondition;
	}
	
	/**
	 * 对传入的JSON数据按所需格式转换并返回
	 * @param old 要转换的数据
	 * @param key 键
	 * @param item 某一项
	 * @param value 值
	 * @return 转换后的json数组
	 */
	public static JSONArray jsonFormatConversion(JSONArray old, String key, String item, String value) {
		Map<String, JSONObject> map = new HashMap<>(16);
		JSONObject object;
		for(int i=0;i<old.length();i++){
			object = old.getJSONObject(i);
			String v_key = object.getString(key);
			String v_item = object.getString(item);	
			int v_test = object.getInt(value);
			String v_value = v_test+"";
			JSONObject temp;
			if(!map.containsKey(v_key)) {
                temp = new JSONObject();
            } else {
                temp = map.get(v_key);
            }
			temp.put(v_item, v_value);
			map.put(v_key, temp);
		}
		
		JSONArray result = new JSONArray();
		Set<String> set = map.keySet();
		for(String str:set){
			JSONObject json = map.get(str);
			json.put(key, str);
			result.put(json);
		}
		return result;
	}

	/**
	 * 构造sql条件
	 * @param conds: [{field: '字段名={}', value: 用户输入值, dateType: 日期类型}]
	 * @param sqlServer: 用于获取数据库方言
	 * @return 产生的sql条件
	 */
	public static String buildCondition(JSONArray conds, SqlServer sqlServer) {
		StringBuilder result = new StringBuilder("1=1");
		for(Object obj : conds) {
			JSONObject cond = (JSONObject)obj;
			String value = cond.getString("value");
			// 按日期类型对值进行处理
			if (cond.has("dateType")) {
				// 是oracle方言，按oracle方式处理
				SessionFactoryImpl impl = (SessionFactoryImpl )sqlServer.sessionFactory;
				String dialect = impl.getDialect().toString();
				if(dialect.indexOf("Oracle") != -1) {
					value = "to_date(" + value + ", 'yyyy-mm-dd hh24:mi:ss')";
				}
			}
			// 替换field中的{}部分为值的内容
			String field = cond.getString("field");
			field = field.replace("{}", value);
			result.append(" and ").append(field);
		}

		return result.toString();
	}

	/**
	 * 生成批量插入语句 INSERT INTO tableName VALUES(),()...
	 * @param data
	 * @param tableName 表名
	 * @param customField 自定义插入字段,不传则是data[0]中所有字段
	 * @return
	 */
	public static String createSQLInsert(JSONArray data,String tableName,ArrayList<String> customField) {
		if (data == null || data.length() <= 0) {
			throw new RuntimeException("传入数据有误");
		}
		if (customField == null) {
			JSONObject jo1 = data.getJSONObject(0);
			ArrayList<String> al1 = new ArrayList<>();
			Iterator<String> it = jo1.keys();
			while (it.hasNext()) {
				al1.add(it.next());
			}
			customField = al1;
		}
		StringBuilder rs = new StringBuilder(data.length() * customField.size() * 10)
				.append("INSERT INTO ").append(tableName).append("(");
		String comma = ",";
		// 加插入字段
		for (String field : customField) {
			rs.append(field).append(comma);
		}
		rs.replace(rs.length() - 1, rs.length(), ")");
		rs.append("VALUES(");
		// 加插入数据
		for (Object object : data) {
			JSONObject o = (JSONObject) object;
			for (String s : customField) {
				Object o1 = o.get(s);
				if (o1 instanceof String) {
					rs.append("\"").append(o1).append("\"").append(comma);
				} else {
					rs.append(o1).append(comma);
				}
			}
			rs.replace(rs.length() - 1, rs.length(), "),(");
		}
		rs.delete(rs.length() - 2, rs.length());
		return rs.toString();
	}
}
