package com.af.plugins;

import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;


/**
 * 
 * Redis连接池及基本方法
 * 
 * @author liuyi
 *
 */
public class RedisTools {
	private static Logger log = Logger.getLogger(RedisTools.class);

	private static JedisPool jedisPool;
	private static JedisPoolConfig config;
	static
	{ 
		// 池基本配置
		config = new JedisPoolConfig();
		config.setMaxTotal(200); 
		config.setMaxIdle(200); 
		config.setMaxWaitMillis(10000); 
		config.setTestOnBorrow(false);
		jedisPool = new JedisPool(config,"127.0.0.1",6379);
	}

	/**
	 *获取jedisPool实例
	 *
	 * @param host redis所在服务器IP
	 * @param port redis端口号
	 */
	public static void getJedisPool(String host,int port){
		jedisPool = new JedisPool(config,host,port);
	}

	/**
	 * 获取jedis实例
	 * @return jedis实例
	 */
	
	public static Jedis getJedis(){
		return jedisPool.getResource();
	}
	
	/**
	 * 获取value值
	 *
	 * @param key 键
	 * @return 根据key获取到的value
	 */
	public static String getValue(String key){
		
		Jedis jedis = getJedis();
		
		String valString = jedis.get(key);
		
		jedis.close();
		
		return valString;
	}

	/**
	 * 添加数据，key已经存在，则不添加，并给出警告日志
	 * @param key  传入的key键
	 * @param value 传入的值
	 */
	public static void addValue(String key, String value) {
		log.info("redis添加数据，key=" + key + ", value=" + value);
		Jedis jedis = getJedis();
		if (jedis.exists(key)) {
			log.warn("redis不能添加数据，key已经存在，key=" + key + ", value=" + value);
		} else {
			jedis.set(key, value);
		}
		jedis.close();
	}

	/**
	 * 添加或修改key对应的value;
	 * 
	 * @param key 传入的key
	 * @param value 需要修改的值
	 * @return 修改后的key和value
	 */
	public static String setValue(String key , String value){
		log.info("redis添加或修改数据，key=" + key + ", value=" + value);

		Jedis jedis = getJedis();
		
		String valString = jedis.set(key,value);

		jedis.close();
		
		return valString;
	}

	/**
	 * 添加或修改key对应的value;
	 *
	 * @param key 传入的key
	 * @param value 需要修改的值
	 * @param redispass redis设置的密码
	 * @return 修改后的key和value
	 */
	public static String setValue(String key , String value, String redispass){
		log.info("redis添加或修改数据，key=" + key + ", value=" + value);

		Jedis jedis = getJedis();

		jedis.auth(redispass);

		String valString = jedis.set(key,value);

		jedis.close();

		return valString;
	}
	
	
	/**
	 * 删除对应的key
	 * @param key 传入需要删除的key
	 * @return 被删除的键的数量
	 */
	public static String removeKey(String key){
		
		Jedis jedis = getJedis();
		
		Long valString = jedis.del(key);
		
		jedis.close();
		
		return valString.toString();
	}
	
	
	
	
	/**
	 * 进行充值
	 * @param key   表号
	 * @param balance  充值金额
	 * @return String结果
	 */
	public static String setBalance(String key, String balance){

		Jedis jedis = getJedis();
		
		String value =jedis.get(key);

		String[] val = value.split(",");

		val[0] =  balance;

		String newValue = splice(val);

		String  result = jedis.set(key, newValue);
		
		jedis.close();

		return result;

	}
	/**
	 *  更改价格,jarry类型
	 *  [{"price":1.98,"amount":100},{"price":2.14,"amount":500},{"price":3.14}]
	 *  [{"price","3.14"}]
	 * @param key 传入需要修改的值的键
	 * @param jObject  json对象
	 * @return 修改结果
	 */
	public static String setPrice(String key, JSONObject jObject){

		Jedis jedis = getJedis();
		
		JSONArray jo = jObject.getJSONArray("arr");

		String value =jedis.get(key);
		String[] val = value.split(",");

		int length = jo.length();

		for(int i = 0;i<length -1 ;i++){
			val[i*2+4] = jo.getJSONObject(i).get("f_price").toString();
			val[i*2+5] = jo.getJSONObject(i).get("f_amount").toString();
		}
		val[length+3] =  jo.getJSONObject(length -1).get("f_price").toString();
		String valueString  =  splice(val);

		String string = jedis.set(key,valueString);

		
		jedis.close();

		return string;
	}
	
	
	/**
	 * 新用户进行添加
	 * 
	 * @param key 需要添加的键
	 * @param jo  需要添加的值
	 * @return String结果
	 */
	public static String setOpen(String key ,JSONObject jo ){

		Jedis jedis = getJedis();
		JSONArray jsonArray = jo.getJSONArray("arr");
		
		JSONObject jObject = jsonArray.getJSONObject(0);
		
		JSONArray jArray  =  jsonArray.getJSONArray(1);
		
		int length = jArray.length();
		
		String [] param = new String[length+4];
		
		param[0] = jObject.get("balance").toString();
		
		param[1] = jObject.get("totalquantity").toString();
		
		param[2] = jObject.get("metertype").toString();
		
		param[3] = jObject.get("prepaytype").toString();
		
		
		
		for(int i = 0;i<length -1 ;i++){
			param[i*2+4] =  jArray.getJSONObject(i).get("f_price").toString();
			param[i*2+5] =  jArray.getJSONObject(i).get("f_amount").toString();
		}
		param[length+3] = jArray.getJSONObject(length -1).get("f_price").toString();
		String valueString  =  splice(param);
		
		String result =  jedis.set(key, valueString);
		
		jedis.close();
		
		return result;

	}

	/**
	 * 字符数组拼接,
	 * @param strings 字符串数组
	 * @return 字符串
	 */
	public static String splice(String[] strings){

		StringBuilder stringBuilder = new StringBuilder();
		for (int i = 0; i < strings.length; i++) {
			if(i == strings.length-1){
				stringBuilder.append(strings[i]);
			}else{
				stringBuilder.append(strings[i]).append(",");
			}
		}
		return stringBuilder.toString();

	}

}
