package com.af.plugins;

import com.alibaba.fastjson.JSONObject;
import org.json.JSONArray;
import scala.annotation.meta.param;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * small tools method
 *
 * @author zhaotong
 *
 */
public class CommonTools {
	/**
	 * 获取一个类的实例
	 * @param className 类名（com.af.plugins.CommonTools）
	 * @param param 构造方法参数
	 * @return 实例
	 */
	public static Object getInstance(String className,JSONArray param){
		Class<?> classInstance;
		try {
			//加载类
			classInstance = Class.forName(className);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		if(param != null && param.length()>0){
			//参数数组
			Object[] objects = new Object[param.length()];
			//参数类型数组
			Class<?>[] paramClasses = new Class[param.length()];
			for(int i=0;i<param.length();i++){
				//获取参数
				objects[i] = param.get(i);
				//获取参数类型
				Class clazz = objects[i].getClass();
				try {
					//如果是基本数据类型
					Field f = clazz.getDeclaredField("TYPE");
					paramClasses[i] = ((Class) f.get(null));
				} catch (NoSuchFieldException e) {
					//如果是类类型
					paramClasses[i] = clazz;
				} catch (IllegalAccessException e) {
					throw new RuntimeException(e);
				}
			}
			//根据构造方法获取实例
			try {
				Constructor constructor = classInstance.getDeclaredConstructor(paramClasses);
				constructor.setAccessible(true);
				return constructor.newInstance(objects);
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		} else {
			try {
				Constructor constructor = classInstance.getDeclaredConstructor();
				constructor.setAccessible(true);
				return constructor.newInstance();
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		}
	}

	/**
	 *  获取一个类的实例（无参）
	 *  @param className 类名（com.af.plugins.CommonTools）
	 *  @return 实例
	 */
	public static Object getInstance(String className){
		return getInstance(className, null);
	}

	/**
	 * 获取一个UUID
	 * @return UUID字符串
	 */
	public static String getUUID(){
		return UUID.randomUUID().toString();
	}

	/**
	 * MD5加密
	 * @param param 需要加密的参数
	 * @return MD5加密后的字符串
	 */
	public static String md5(String param) {
		char[] hexDigits = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
				'a', 'b', 'c', 'd', 'e', 'f'};
		try {
			byte[] strTemp = param.getBytes(StandardCharsets.UTF_8);
			MessageDigest mdTemp = MessageDigest.getInstance("MD5");
			mdTemp.update(strTemp);
			byte[] md = mdTemp.digest();
			int j = md.length;
			char[] str = new char[j * 2];
			int k = 0;
			for (byte byte0 : md) {
				str[k++] = hexDigits[byte0 >>> 4 & 0xf];
				str[k++] = hexDigits[byte0 & 0xf];
			}
			return new String(str);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * 获取一个指定范围的伪随机数
	 * @param min 最小值
	 * @param max 最大值
	 * @return 伪随机数
	 */
	public static int getRandomNumber(Integer min,Integer max){
		return (int)(Math.random()*(max-min+1)+min);
	}

	/**
	 * 将字符串类型转换为Double
	 * @return enum
	 * @param param 构造方法参数
	 */
	public static Double stringToDouble(String param){
		return Double.valueOf(param);
	}

	// 判断参数是否包含字母
	public static boolean judgeContainsStr(String cardNum) {
		String regex = ".*[a-zA-Z]+.*";
		Matcher m = Pattern.compile(regex).matcher(cardNum);
		return m.matches();
	}

	// 判断包含有数字和字母的字符串，在最后一个字母之后的第一个非零数字的索引
	public static int indexNumber(String value) {
		char[] ch = value.toCharArray();
		int result = 0;
		for (int i = indexCharacter(value) + 1; i < ch.length; i++) {
			if (ch[i] != 0) {
				result = i;
				break;
			}
		}
		return result;
	}

	// 判断包含有数字和字母的字符串中，最后一个字母出现的位置的索引
	public static int indexCharacter(String value) {
		char[] ch = value.toCharArray();
		int flag = 0;
		for (int i = ch.length - 1; i >= 0; i--) {
			if (ch[i] < '0' || ch[i] > '9') {
				flag = i;
				break;
			}
		}
		System.out.println(flag);
		return flag;
	}

	// 给定包含有字母和数字的字符串区间生成所有范围值，用于地址和表号的批量生成
	/**
	 * @return 集合
	 * @param value example:"1,2" or "A01001,A01010"
	 */
	public static List<String> getStringBatch(String value) {

		List<String> list = new ArrayList<>();

		if (value.contains(",")) {
			String start = value.split(",")[0];
			String end = value.split(",")[1];
			if (!CommonTools.judgeContainsStr(start)
					&& !CommonTools.judgeContainsStr(end)) {
				String format = "%0" + end.length() + "d";
				for (int i = Integer.parseInt(start); i <= Integer
						.parseInt(end); i++) {
					list.add(String.valueOf(String.format(format, i)));
				}
			} else if (CommonTools.judgeContainsStr(start)
					&& CommonTools.judgeContainsStr(end)) {

				String format = "%0"
						+ String.valueOf(end.length()
								- (CommonTools.indexCharacter(end) + 1)) + "d";
				String str = end.substring(0,
						CommonTools.indexCharacter(end) + 1);
				for (int i = getNumber(start); i <= getNumber(end); i++) {
					list.add(str + String.format(format, i));
				}

			} else {
				System.out.println("data error");
			}

		} else {
			list.add(value);
		}

		return list;
	}

	private static int getNumber(String value) {
		return Integer.parseInt(value.substring(
				CommonTools.indexNumber(value) + 1));
	}

	/**
	 * 字符串加1操作，，目前只支持加1，
	 *
	 * @param a 字符串a
	 * @param b 字符串b
	 * @return 字符串
     * @throws Exception 异常
	 */
	public static String strAdd(String a, int b) throws Exception{

		String result;
		if (a.length() == 1) {
			try{
				return Integer.parseInt(a) + 1 + "";
			}catch(Exception e) {
				throw new Exception("编号" + a + "不能加一");
			}
		}
		// 获取前一半
		String first = a.substring(0,a.length()/2);
		// 截取一半
		String last = a.substring(a.length() / 2);
		// 后半部分加一之后
		int temp = new Integer(last) + 1;
		StringBuilder sb = new StringBuilder();

		if (Integer.toString(temp).length() <= last.length()) {
			// 用零不全
			for (int i = 0; i < (last.length() - Integer.toString(temp).length()); i++) {
				sb.append("0");
			}
			result = first + sb.toString() + Integer.toString(temp);

		} else {
			for (int i = 0; i< last.length(); i++) {
				sb.append("0");
			}
			first = new Integer(first) + 1 + "";

			result = first + sb.toString();
		}

		return result;

	}

	/**
	 * 精确加法运算
	 * @param o1 对象
	 * @param o2 对象
	 * @return BigDecimal
	 */
	public static BigDecimal add(Object o1, Object o2) {
		BigDecimal b1;
		BigDecimal b2;
		if (o1 instanceof Integer) {
			b1 = new BigDecimal((Integer) o1);
		} else if (o1 instanceof String) {
			b1 = new BigDecimal((String) o1);
		} else {
			b1 = (BigDecimal) o1;
		}
		if (o2 instanceof Integer) {
			b2 = new BigDecimal((Integer) o2);
		} else if (o2 instanceof String) {
			b2 = new BigDecimal((String) o2);
		} else {
			b2 = (BigDecimal) o2;
		}

		return b1.add(b2);
	}

	/**
	 * 精确加法运算 可以传入精度
	 * @param scale 精度
	 * @param o1 对象
	 * @param o2	对象
	 * @return BigDecimal
	 */
	public static BigDecimal add(Object o1, Object o2, int scale) {
		if (scale < 0) {
			throw new IllegalArgumentException("精度不能小于0");
		}
		BigDecimal result = add(o1, o2);
		return result.setScale(scale, BigDecimal.ROUND_HALF_UP);
	}

	/**
	 * 精确减法运算
	 * @param  o1 对象
	 * @param o2 对象
	 * @return BigDecimal
	 */
	public static BigDecimal sub(Object o1, Object o2) {
		BigDecimal b1;
		BigDecimal b2;
		if (o1 instanceof Integer) {
			b1 = new BigDecimal((Integer) o1);
		} else if (o1 instanceof String) {
			b1 = new BigDecimal((String) o1);
		} else {
			b1 = (BigDecimal) o1;
		}
		if (o2 instanceof Integer) {
			b2 = new BigDecimal((Integer) o2);
		} else if (o2 instanceof String) {
			b2 = new BigDecimal((String) o2);
		} else {
			b2 = (BigDecimal) o2;
		}

		return b1.subtract(b2);
	}

	/**
	 * 精确减法运算 可以传入精度
	 * @param scale 精度
	 * @param o1 对象
	 * @param o2 对象
	 * @return BigDecimal
	 */
	public static BigDecimal sub(Object o1, Object o2, int scale) {
		if (scale < 0) {
			throw new IllegalArgumentException("精度不能小于0");
		}
		BigDecimal result = sub(o1, o2);
		return result.setScale(scale, BigDecimal.ROUND_HALF_UP);
	}

	/**
	 * 精确乘法运算
     * @param o1 对象
     * @param o2 对象
     * @return  double类型的结果
	 */
	public static double mul(Object o1, Object o2) {
		BigDecimal b1;
		BigDecimal b2;
		if (o1 instanceof Integer) {
			b1 = new BigDecimal((Integer) o1);
		} else if (o1 instanceof String) {
			b1 = new BigDecimal((String) o1);
		} else {
			b1 = (BigDecimal) o1;
		}
		if (o2 instanceof Integer) {
			b2 = new BigDecimal((Integer) o2);
		} else if (o2 instanceof String) {
			b2 = new BigDecimal((String) o2);
		} else {
			b2 = (BigDecimal) o2;
		}
		return b1.multiply(b2).doubleValue();
	}

	/**
	 * 精确乘法运算 可以传入精度
	 * @param  scale 精度
	 * @param o1 对象
	 * @param o2 对象
	 * @return BigDecimal
	 */
	public static BigDecimal mul(Object o1, Object o2, int scale) {
		if (scale < 0) {
			throw new IllegalArgumentException("精度不能小于0");
		}
		double result = mul(o1, o2);
		return new BigDecimal(result).setScale(scale, BigDecimal.ROUND_HALF_UP);
	}

	/**
	 * 提供（相对）精确的除法运算，当发生除不尽的情况时，默认精确到 小数点以后10位，以后的数字四舍五入。
     * @param o1  对象
     * @param o2  对象
     * @return double类型的结果
	 */
	public static double div(Object o1, Object o2) {
		BigDecimal b1;
		BigDecimal b2;
		if (o1 instanceof Integer) {
			b1 = new BigDecimal((Integer) o1);
		} else if (o1 instanceof String) {
			b1 = new BigDecimal((String) o1);
		} else {
			b1 = (BigDecimal) o1;
		}
		if (o2 instanceof Integer) {
			b2 = new BigDecimal((Integer) o2);
		} else if (o2 instanceof String) {
			b2 = new BigDecimal((String) o2);
		} else {
			b2 = (BigDecimal) o2;
		}
		return div(b1, b2, 10);
	}

	/**
	 * 除法运算, 当发生除不尽的情况时, 由scale参数指定精度, 以后的数字四舍五入
     * @param o2  对象
     * @param o1  对象
     * @return  double类型的结果集
     * @param scale 精度
	 */
	public static double div(Object o1, Object o2, int scale) {
		if (scale < 0) {
			throw new IllegalArgumentException("精度不能小于0");
		}
		BigDecimal b1;
		BigDecimal b2;
		if (o1 instanceof Integer) {
			b1 = new BigDecimal((Integer) o1);
		} else if (o1 instanceof String) {
			b1 = new BigDecimal((String) o1);
		} else {
			b1 = (BigDecimal) o1;
		}
		if (o2 instanceof Integer) {
			b2 = new BigDecimal((Integer) o2);
		} else if (o2 instanceof String) {
			b2 = new BigDecimal((String) o2);
		} else {
			b2 = (BigDecimal) o2;
		}
		return b1.divide(b2, scale, BigDecimal.ROUND_HALF_UP).doubleValue();
	}

	/**
	 * 字符串分割
     * @param str 字符串
     * @param separator 以什么方式分割
     * @return JSONArray 集合
	 */
	public static JSONArray split(String str, String separator) {
		if ("|".equals(separator) || "*".equals(separator)
				|| "^".equals(separator)) {
			separator = "\\\\" + separator;
		}
		JSONArray result = new JSONArray();
		if (str != null) {
			for (String value : str.split(separator)) {
				result.put(value);
			}
		}
		return result;
	}
	/**
	 * 截取字符串
	 * @param str 字符串
	 * @param start 从什么地方开始
	 * @param end 到什么地方结束
	 * @return 截取好的字符串
	 */
	public static String substring(String str, int start, int end) {
		return str.substring(start, end);
	}

	public static boolean isContains(String str, String target) {
		return str.contains(target);
	}

	/**
	 * 将两个字符串按逗号拼接
     * @param str1 字符串1
     * @param str2  字符串2
     * @return 拼接好的字符串
	 */
	public static String union(String str1, String str2) {
		// 全空返回空
		if ("".equals(str1) && "".equals(str2)) {
			return "";
		}
		if (!"".equals(str1) && "".equals(str2)) {
			return str1;
		}
		if ("".equals(str1) && !"".equals(str2)) {
			return str2;
		}

		// 两个都不为空，返回逗号连接的字符串
		return str1 + "," + str2;
	}

	/**
	 * 合并一个JSON数组里的所有字符串，形式为：'a','b'
     * @param array 传入一个json数组
     * @return 合并后的字符串
	 */

	public static String union(JSONArray array) {
		StringBuilder result = new StringBuilder();
		for(Object obj : array) {
			String str = (String)obj;
			if (!"".equals(result.toString())) {
				result.append(",");
			}
			result.append("'").append(str).append("'");
		}
		return result.toString();
	}

	/**
	 * 格式化参数字符串
	 * @param str 需要格式化的参数字符串，格式：http://{baseUrl}/rs/logic/{logicName}
	 * @param parametricMap 参数映射字典，如：baseUrl: baidu.com , logicName: beta
	 * @return 格式化后的参数字符串，结果：http://baidu.com/rs/logic/beta
	 */
	public static String parametricStr(String str, Map parametricMap){
		boolean isReplace = str.contains("{") && str.contains("}");
		if(isReplace){
			char[] strArray = str.toCharArray();
			StringBuilder replaceStr = new StringBuilder();
			do {
				int start = str.indexOf("{");
				int end = str.indexOf("}");
				//获得需要被替换的key
				for (int i = start + 1; i < end; i++) {
					replaceStr.append(strArray[i]);
				}
				//读取根据key映射字典的值
				String param = String.valueOf(parametricMap.get(replaceStr.toString()));
				//替换字符
				if(!param.equals("null")) {
					str = str.replace("{" + replaceStr + "}", param);
					//清空缓存
					replaceStr.setLength(0);
					strArray = str.toCharArray();
					//重新判断
					isReplace = start != -1 && end != -1;
				} else {
					return str;
				}
			} while (isReplace);
		}
		return str;
	}
}
