/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.timeoutReturn;

import com.aote.util.ResourceHelper;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Component
public class RedisCacheTools {
    private static Logger log = Logger.getLogger(RedisCacheTools.class);
    private static JedisPool jedisPool;
    private static JedisPoolConfig config;

    public void getJedisPool(String host, int port) {
        jedisPool = new JedisPool((GenericObjectPoolConfig)config, host, port);
    }

    public Jedis getJedis() {
        return jedisPool.getResource();
    }

    public String getValue(String key) {
        Jedis jedis = this.getJedis();
        String valString = jedis.get(key);
        jedis.close();
        return valString;
    }

    public String setValue(String key, String value, int timeout) {
        if (timeout <= 0) {
            timeout = 1800;
        }
        Jedis jedis = this.getJedis();
        String valString = jedis.setex(key, timeout, value.toString());
        jedis.close();
        return valString;
    }

    public String setValue(String key, String value) {
        Jedis jedis = this.getJedis();
        String valString = jedis.setex(key, 1800, value.toString());
        jedis.close();
        return valString;
    }

    public String removeKey(String key) {
        Jedis jedis = this.getJedis();
        Long valString = jedis.del(key);
        jedis.close();
        return valString.toString();
    }

    static {
        config = new JedisPoolConfig();
        config.setMaxTotal(200);
        config.setMaxIdle(200);
        config.setMaxWaitMillis(10000L);
        config.setTestOnBorrow(false);
        try {
            String strConfig = ResourceHelper.getString((String)"config.json");
            JSONObject jsonObject = new JSONObject(strConfig);
            if (!jsonObject.has("logicRegister")) {
                jedisPool = new JedisPool((GenericObjectPoolConfig)config, "127.0.0.1", 6379);
            } else {
                JSONObject logicJsonObject = jsonObject.getJSONObject("logicRegister");
                String url = logicJsonObject.getString("url");
                JSONObject redisObject = logicJsonObject.getJSONObject("redis");
                String redisHost = redisObject.getString("host");
                int redisPort = redisObject.getInt("port");
                jedisPool = new JedisPool((GenericObjectPoolConfig)config, redisHost, redisPort);
            }
        }
        catch (Exception e) {
            log.debug((Object)"\u83b7\u53d6config.json redis\u914d\u7f6e\u5931\u8d25\uff01\uff01");
        }
    }
}

