/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.kafka.kafka_producer;

import java.io.IOException;
import java.util.Properties;
import java.util.Random;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaProducerSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaProducerSingleton.class);
    private static KafkaProducer<String, String> kafkaProducer;
    private Random random = new Random();
    private String topic;
    private int retry;

    private KafkaProducerSingleton() {
    }

    public static KafkaProducerSingleton getInstance() {
        return LazyHandler.instance;
    }

    public void init(String topic, int retry) {
        this.topic = topic;
        this.retry = retry;
        if (null == kafkaProducer) {
            Properties prop = new Properties();
            try {
                prop.load(KafkaProducerSingleton.class.getResourceAsStream("/kafka_producer.properties"));
                kafkaProducer = new KafkaProducer(prop);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendKafkaMessage(String topic, int partitionNum, String message) {
        ProducerRecord record = new ProducerRecord(topic, Integer.valueOf(this.random.nextInt(partitionNum)), (Object)"", (Object)message);
        kafkaProducer.send(record, (recordMetadata, exception) -> {
            if (null != exception) {
                LOGGER.error("kafka\u53d1\u9001\u6d88\u606f\u5931\u8d25:" + exception.getMessage(), (Throwable)exception);
                this.retryKakfaMessage(topic, partitionNum, message);
            }
        });
    }

    private void retryKakfaMessage(String retryTopic, int retryPartitionNum, String retryMessage) {
        ProducerRecord record = new ProducerRecord(retryTopic, Integer.valueOf(retryPartitionNum), (Object)"", (Object)retryMessage);
        for (int i = 1; i <= this.retry; ++i) {
            try {
                kafkaProducer.send(record);
                return;
            }
            catch (Exception e) {
                LOGGER.error("kafka\u53d1\u9001\u6d88\u606f\u5931\u8d25:" + e.getMessage(), (Throwable)e);
                this.retryKakfaMessage(retryTopic, retryPartitionNum, retryMessage);
                continue;
            }
        }
    }

    public void close() {
        if (null != kafkaProducer) {
            kafkaProducer.close();
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getRetry() {
        return this.retry;
    }

    public void setRetry(int retry) {
        this.retry = retry;
    }

    private static class LazyHandler {
        private static final KafkaProducerSingleton instance = new KafkaProducerSingleton();

        private LazyHandler() {
        }
    }
}

