/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.kafka.kafka_consumer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.json.JSONArray;
import org.json.JSONObject;

public class TopicTools {
    private static String brokerUrl;
    private static AdminClient adminClient;
    private static Set<String> topicList;
    private static JSONArray topicConfigList;

    private static void initConfig() {
        JSONObject topicConfig = TopicTools.readJsonFile();
        brokerUrl = topicConfig.getString("brokerUrl");
        topicConfigList = topicConfig.getJSONArray("topics");
        TopicTools.openClient();
    }

    private static void openClient() {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", brokerUrl);
        adminClient = AdminClient.create((Properties)properties);
    }

    private static void closeClient() {
        adminClient.close();
    }

    private static void createTopics() {
        ArrayList<NewTopic> newTopicList = new ArrayList<NewTopic>();
        for (int i = 0; i < topicConfigList.length(); ++i) {
            JSONObject topic = topicConfigList.getJSONObject(i);
            String topicName = topic.getString("logicName");
            if (topicList.contains(topicName)) continue;
            NewTopic newTopic = new NewTopic(topicName, 3, 1);
            System.out.println("\u91cd\u5efatopic[" + topicName + "]\u4e2d...");
            newTopicList.add(newTopic);
        }
        if (newTopicList.size() > 0) {
            adminClient.createTopics(newTopicList);
        } else {
            System.out.println("\u6ca1\u6709\u53ef\u4ee5\u91cd\u5efa\u7684topic");
        }
    }

    public static void deleteAllTopics() {
        adminClient.deleteTopics(topicList);
    }

    private static void deleteTopicForName(String topicName) {
        adminClient.deleteTopics(Collections.singletonList(topicName));
    }

    private static Set<String> viewTopics() throws ExecutionException, InterruptedException {
        ListTopicsResult topics = adminClient.listTopics();
        return (Set)topics.names().get();
    }

    public static void main(String[] args) throws ExecutionException, InterruptedException {
        Scanner scanner = new Scanner(System.in);
        boolean isExit = false;
        topicList = TopicTools.viewTopics();
        System.out.println("kafka-topic\u7ba1\u7406\u5de5\u5177V1.0 by Mr.river");
        System.out.println("\u5f53\u524dtopic\u5217\u8868\uff1a" + topicList);
        System.out.println("------------------");
        System.out.println("\u64cd\u4f5c\u83dc\u5355\uff1a");
        System.out.println("1.\u91cd\u5efa\u6240\u6709topic");
        System.out.println("2.\u67e5\u770b\u5f53\u524dtopic\u5217\u8868");
        System.out.println("3.\u5220\u9664\u6307\u5b9a\u540d\u79f0\u7684topic");
        System.out.println("4.\u9000\u51fa");
        System.out.println("------------------");
        while (true) {
            int choose;
            System.out.print("\u8bf7\u9009\u62e9\uff1a");
            try {
                choose = Integer.parseInt(scanner.next());
            }
            catch (Exception exception) {
                continue;
            }
            switch (choose) {
                case 1: {
                    TopicTools.createTopics();
                    System.out.println("\u91cd\u5efa\u6240\u6709topic------\u64cd\u4f5c\u5b8c\u6210");
                    break;
                }
                case 2: {
                    System.out.println("=====================");
                    topicList = TopicTools.viewTopics();
                    System.out.println("\u5f53\u524dtopic\u5217\u8868\uff1a" + topicList);
                    break;
                }
                case 3: {
                    System.out.println("\u64cd\u4f5c\u88ab\u7981\u7528");
                    break;
                }
                case 4: {
                    isExit = true;
                    break;
                }
                default: {
                    System.out.println("\u672a\u77e5\u7684\u9009\u9879");
                }
            }
            if (isExit) break;
        }
        TopicTools.closeClient();
    }

    private static JSONObject readJsonFile() {
        BufferedReader reader = null;
        StringBuilder laststr = new StringBuilder();
        try {
            String tempString;
            InputStream input = TopicTools.class.getResourceAsStream("/topicConfig.json");
            InputStreamReader inputStreamReader = new InputStreamReader(input, StandardCharsets.UTF_8);
            reader = new BufferedReader(inputStreamReader);
            while ((tempString = reader.readLine()) != null) {
                laststr.append(tempString);
            }
            reader.close();
            JSONObject jSONObject = new JSONObject(laststr.toString());
            return jSONObject;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        TopicTools.initConfig();
    }
}

