/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import com.af.plugins.Base64Utils;
import com.aote.util.JsonHelper;
import java.math.BigInteger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class AESUtil {
    private static final String ALGORITHMSTR = "AES/ECB/PKCS5Padding";

    public static String encrypt(String content, String encryptKey) {
        try {
            return AESUtil.aesEncrypt(content, encryptKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String decrypt(String content, String encryptKey) {
        try {
            return AESUtil.aesDecrypt(content, encryptKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String binary(byte[] bytes, int radix) {
        return new BigInteger(1, bytes).toString(radix);
    }

    public static byte[] aesEncryptToBytes(String content, String encryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(1, new SecretKeySpec(encryptKey.getBytes(), "AES"));
        return cipher.doFinal(content.getBytes("utf-8"));
    }

    public static String aesEncrypt(String content, String encryptKey) throws Exception {
        return Base64Utils.encode(AESUtil.aesEncryptToBytes(content, encryptKey));
    }

    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(2, new SecretKeySpec(decryptKey.getBytes(), "AES"));
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes, "UTF-8");
    }

    public static String aesDecrypt(String encryptStr, String decryptKey) throws Exception {
        return StringUtils.isEmpty((CharSequence)encryptStr) ? null : AESUtil.aesDecryptByBytes(Base64Utils.decodeBuffer(encryptStr), decryptKey);
    }

    public static String addDecrypt(String paramStr) {
        JSONObject configJson = JsonHelper.getConfig();
        if (configJson.has("isEncrypt") && configJson.getBoolean("isEncrypt") || configJson.has("isNeed") && configJson.getBoolean("isNeed")) {
            String encryKey = configJson.getString("encryKey");
            return AESUtil.encrypt(paramStr, encryKey);
        }
        return paramStr;
    }

    public static String getEncrypt(String str) {
        JSONObject configJson = JsonHelper.getConfig();
        if (configJson.has("isEncrypt") && configJson.getBoolean("isEncrypt") || configJson.has("isNeed") && configJson.getBoolean("isNeed")) {
            String encryKey = configJson.getString("encryKey");
            return AESUtil.decrypt(str, encryKey);
        }
        return str;
    }
}

