/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import com.af.plugins.Config;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class HttpAsyncConnectionPoolUtil {
    private static final Logger logger = Logger.getLogger(HttpAsyncConnectionPoolUtil.class);
    private static final int CONNECT_TIMEOUT = Config.getConnectTimeout();
    private static final int SOCKET_TIMEOUT = Config.getConnectTimeout();
    private static final int MAX_CONN = Config.getHttpMaxPoolSize();
    private static CloseableHttpAsyncClient httpClient;
    private static final Object syncLock;

    private static void setRequestConfig(HttpRequestBase httpRequestBase) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(CONNECT_TIMEOUT).setConnectTimeout(CONNECT_TIMEOUT).setSocketTimeout(SOCKET_TIMEOUT).build();
        httpRequestBase.setConfig(requestConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpAsyncClient getHttpClient() {
        if (httpClient == null) {
            Object object = syncLock;
            synchronized (object) {
                if (httpClient == null) {
                    httpClient = HttpAsyncConnectionPoolUtil.createHttpClient();
                }
            }
        }
        httpClient.start();
        return httpClient;
    }

    public static CloseableHttpAsyncClient getHttpClient(SSLIOSessionStrategy sslSocketFactory) {
        return HttpAsyncConnectionPoolUtil.createHttpClient(sslSocketFactory);
    }

    private static CloseableHttpAsyncClient createHttpClient() {
        return HttpAsyncConnectionPoolUtil.createHttpClient(null);
    }

    private static CloseableHttpAsyncClient createHttpClient(SSLIOSessionStrategy sslSocketFactory) {
        if (sslSocketFactory == null) {
            logger.debug((Object)"\u521b\u5efaHTTP\u5f02\u6b65\u5ba2\u6237\u7aef\u4f1a\u8bdd");
            sslSocketFactory = SSLIOSessionStrategy.getDefaultStrategy();
        } else {
            logger.debug((Object)"\u521b\u5efahttps\u5f02\u6b65\u5ba2\u6237\u7aef\u4f1a\u8bdd");
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)sslSocketFactory).build();
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors()).setSoKeepAlive(true).build();
        DefaultConnectingIOReactor ioReactor = null;
        try {
            ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
        }
        catch (IOReactorException e) {
            e.printStackTrace();
        }
        PoolingNHttpClientConnectionManager manager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor, registry);
        manager.setMaxTotal(MAX_CONN);
        manager.setDefaultMaxPerRoute(MAX_CONN);
        ConnectionKeepAliveStrategy myStrategy = (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !"timeout".equalsIgnoreCase(param)) continue;
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            HttpHost target = (HttpHost)context.getAttribute("http.target_host");
            if ("www.naughty-server.com".equalsIgnoreCase(target.getHostName())) {
                return 5000L;
            }
            return 30000L;
        };
        return HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)manager).setKeepAliveStrategy(myStrategy).build();
    }

    public static SSLContext createIgnoreVerifySSL() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = null;
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)((TrustStrategy)(chain, authType) -> true)).build();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return sslContext;
    }

    private static void setPostParams(HttpEntityEnclosingRequestBase base, String params) {
        if (params != null && !"".equals(params)) {
            StringEntity se = new StringEntity(params, StandardCharsets.UTF_8);
            base.setEntity((HttpEntity)se);
        }
    }

    private static void setHeaders(HttpRequestBase base, String headersStr) {
        if (headersStr != null && !"".equals(headersStr)) {
            JSONObject headers = new JSONObject(headersStr);
            Iterator keys = headers.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String val = headers.getString(key);
                base.setHeader(key, val);
            }
        }
    }

    public static void request(String path, String value, String headersStr, HttpRequestBase base) throws IOException {
        HttpAsyncConnectionPoolUtil.request(path, value, headersStr, base, HttpAsyncConnectionPoolUtil.getHttpClient());
    }

    public static void request(String path, String value, String headersStr, HttpRequestBase base, CloseableHttpAsyncClient httpClient) {
        HttpAsyncConnectionPoolUtil.setRequestConfig(base);
        if (base instanceof HttpEntityEnclosingRequestBase) {
            HttpAsyncConnectionPoolUtil.setPostParams((HttpEntityEnclosingRequestBase)base, value);
        }
        HttpAsyncConnectionPoolUtil.setHeaders(base, headersStr);
        base.setURI(URI.create(path));
        long begin = System.currentTimeMillis();
        httpClient.execute((HttpUriRequest)base, (FutureCallback)new InnerAsyncResponse());
        long end = System.currentTimeMillis();
        long time = end - begin;
        String text = "\u8bf7\u6c42\u63a5\u53e3\u8017\u65f6\uff1a" + time + "ms";
        if (time >= 500L) {
            logger.warn((Object)text);
        } else {
            logger.info((Object)text);
        }
    }

    public static void closeConnectionPool(CloseableHttpAsyncClient httpClient) {
        try {
            httpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void requestFormUrlEncoded(String path, JSONObject params, HttpEntityEnclosingRequestBase base, CloseableHttpAsyncClient httpClient) throws IOException {
        HttpAsyncConnectionPoolUtil.setRequestConfig((HttpRequestBase)base);
        base.setURI(URI.create(path));
        base.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpAsyncConnectionPoolUtil.paramsConverter(params)));
        long begin = System.currentTimeMillis();
        httpClient.execute((HttpUriRequest)base, (FutureCallback)new InnerAsyncResponse());
        long end = System.currentTimeMillis();
        long time = end - begin;
        String text = "\u8bf7\u6c42\u63a5\u53e3\u8017\u65f6\uff1a" + time + "ms";
        if (time >= 500L) {
            logger.warn((Object)text);
        } else {
            logger.info((Object)text);
        }
    }

    public static void requestFormUrlEncoded(String path, Map<String, String> params, HttpEntityEnclosingRequestBase base, CloseableHttpAsyncClient httpClient) throws IOException {
        HttpAsyncConnectionPoolUtil.requestFormUrlEncoded(path, new JSONObject(params), base, httpClient);
    }

    private static List<NameValuePair> paramsConverter(JSONObject params) {
        LinkedList<NameValuePair> nvps = new LinkedList<NameValuePair>();
        Set paramsSet = params.keySet();
        for (String key : paramsSet) {
            nvps.add((NameValuePair)new BasicNameValuePair(key, params.getString(key)));
        }
        return nvps;
    }

    static {
        syncLock = new Object();
    }

    public static class InnerAsyncResponse
    implements FutureCallback<HttpResponse> {
        public void completed(HttpResponse result) {
            String resStr = null;
            String code = String.valueOf(result.getStatusLine().getStatusCode());
            if (code.startsWith("2")) {
                HttpEntity entity = result.getEntity();
                if (entity != null) {
                    try {
                        resStr = EntityUtils.toString((HttpEntity)result.getEntity(), (Charset)StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                String errorEntity = null;
                String data = result.getStatusLine().getReasonPhrase();
                HttpEntity entity = result.getEntity();
                if (entity != null) {
                    try {
                        errorEntity = EntityUtils.toString((HttpEntity)result.getEntity(), (Charset)StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    errorEntity = "";
                }
                resStr = "{status: " + code + ", data: '" + data + "', errorEntity: '" + errorEntity + "'}";
            }
            logger.debug((Object)("\u5f02\u6b65\u8bf7\u6c42\u7ed3\u679c\uff1a" + resStr));
        }

        public void failed(Exception ex) {
            throw new RuntimeException(ex);
        }

        public void cancelled() {
        }
    }
}

